*                                                                                  ;
 *    Reading in the 1985 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam85.raw' ;
 
 data one;
 
   infile 'F:\PSID\85FAM.DAT'  lrecl=2456 missover;
   INPUT
   V11101 1-3             V11102 4-7             V11103 8-9
   V11104 10-12           V11105 13-17           V11106 18
   V11107 19              V11108 20              V11109 21
   V11110 22              V11111 23              V11112 24
   V11113 25              V11114 26              V11115 27
   V11116 28              V11117 29              V11118 30-33
   V11119 34-36           V11120 37-38           V11121 39
   V11122 40-41           V11123 42              V11124 43
   V11125 44-49           V11126 50              V11127 51-56
   V11128 57              V11129 58-62           V11130 63
   V11131 64-68           V11132 69              V11133 70-74
   V11134 75              V11135 76-79           V11136 80
   V11137 81-85           V11138 86              V11139 87-90
   V11140 91-94           V11141 95              V11142 96-99
   V11143 100             V11144 101-104         V11145 105
   V11146 106-109         V11147 110-113         V11148 114
   V11149 115-118         V11150 119             V11151 120-123
   V11152 124             V11153 125-128         V11154 129
   V11155 130-133         V11156 134             V11157 135-137
   V11158 138             V11159 139             V11160 140
   V11161 141             V11162 142             V11163 143
   V11164 144             V11165 145             V11166 146
   V11167 147             V11168 148             V11169 149
   V11170 150             V11171 151             V11172 152
   V11173 153             V11174 154             V11175 155
   V11176 156             V11177 157             V11178 158
   V11179 159             V11180 160             V11181 161
   V11182 162             V11183 163             V11184 164
   V11185 165             V11186 166             V11187 167
   V11188 168             V11189 169             V11190 170
   V11191 171             V11192 172             V11193 173
   V11194 174             V11195 175             V11196 176
   V11197 177             V11198 178             V11199 179
   V11200 180             V11201 181             V11202 182
   V11203 183             V11204 184             V11205 185
   V11206 186             V11207 187             V11208 188
   V11209 189             V11210 190             V11211 191
   V11212 192             V11213 193             V11214 194
   V11215 195             V11216 196             V11217 197
   V11218 198             V11219 199             V11220 200
   V11221 201             V11222 202             V11223 203
   V11224 204             V11225 205             V11226 206
   V11227 207             V11228 208             V11229 209
   V11230 210             V11231 211             V11232 212
   V11233 213             V11234 214             V11235 215
   V11236 216             V11237 217             V11238 218
   V11239 219             V11240 220             V11241 221
   V11242 222             V11243 223             V11244 224
   V11245 225             V11246 226             V11247 227
   V11248 228             V11249 229             V11250 230
   V11251 231             V11252 232-235         V11253 236
   V11254 237-240         V11255 241             V11256 242-245
   V11257 246             V11258 247-250         V11259 251-254
   V11260 255             V11261 256-259         V11262 260
   V11263 261-264         V11264 265             V11265 266-269
   V11266 270             V11267 271-274         V11268 275
   V11269 276-278         V11270 279             V11271 280
   V11272 281             V11273 282             V11274 283
   V11275 284             V11276 285             V11277 286
   V11278 287             V11279 288             V11280 289
   V11281 290             V11282 291             V11283 292
   V11284 293             V11285 294             V11286 295
   V11287 296             V11288 297             V11289 298
   V11290 299             V11291 300             V11292 301
   V11293 302             V11294 303             V11295 304
   V11296 305             V11297 306             V11298 307
   V11299 308             V11300 309             V11301 310
   V11302 311             V11303 312             V11304 313
   V11305 314             V11306 315             V11307 316
   V11308 317             V11309 318             V11310 319
   V11311 320             V11312 321             V11313 322
   V11314 323             V11315 324             V11316 325
   V11317 326             V11318 327             V11319 328
   V11320 329             V11321 330             V11322 331
   V11323 332             V11324 333             V11325 334
   V11326 335             V11327 336             V11328 337
   V11329 338             V11330 339             V11331 340
   V11332 341             V11333 342             V11334 343
   V11335 344             V11336 345             V11337 346
   V11338 347             V11339 348             V11340 349
   V11341 350             V11342 351             V11343 352
   V11344 353             V11345 354             V11346 355
   V11347 356             V11348 357             V11349 358
   V11350 359             V11351 360             V11352 361
   V11353 362             V11354 363             V11355 364
   V11356 365             V11357 366             V11358 367
   V11359 368             V11360 369             V11361 370
   V11362 371             V11363 372             V11364 373-374
   V11365 375             V11366 376-379         V11367 380
   V11368 381-384         V11369 385             V11370 386-389
   V11371 390             V11372 391             V11373 392-394
   V11374 395             V11375 396-400         V11376 401
   V11377 402-405         V11378 406             V11379 407-410
   V11380 411             V11381 412-413         V11382 414
   V11383 415             V11384 416             V11385 417
   V11386 418             V11387 419             V11388 420
   V11389 421             V11390 422             V11391 423
   V11392 424             V11393 425             V11394 426
   V11395 427-431         V11396 432-436         V11397 437-442
   V11398 443             V11399 444-448         V11400 449-454
   V11401 455-459         V11402 460-464         V11403 465
   V11404 466-471         V11405 472             V11406 473-478
   V11407 479-484         V11408 485-489         V11409 490-494
   V11410 495-500         V11411 501-502         V11412 503-508
   V11413 509-510         V11414 511-516         V11415 517-518
   V11416 519-524         V11417 525-530         V11418 531
   V11419 532-538         V11420 539-543         V11421 544-548
   V11422 549-553         V11423 554             V11424 555-556
   V11425 557             V11426 558             V11427 559-563
   V11428 564             V11429 565-566         V11430 567-571
   V11431 572-576         V11432 577-578         V11433 579-583
   V11434 584             V11435 585-586         V11436 587-591
   V11437 592-593         V11438 594-598         V11439 599
   V11440 600-604         V11441 605-609         V11442 610-611
   V11443 612-616         V11444 617-618         V11445 619-623
   V11446 624-625         V11447 626-630         V11448 631-632
   V11449 633-637         V11450 638-639         V11451 640-644
   V11452 645-649         V11453 650-654         V11454 655-656
   V11455 657-661         V11456 662-663         V11457 664-668
   V11458 669-670         V11459 671-675         V11460 676
   V11461 677-681         V11462 682             V11463 683
   V11464 684             V11465 685             V11466 686
   V11467 687             V11468 688             V11469 689
   V11470 690             V11471 691             V11472 692
   V11473 693             V11474 694             V11475 695
   V11476 696             V11477 697             V11478 698
   V11479 699             V11480 700             V11481 701
   V11482 702             V11483 703             V11484 704
   V11485 705             V11486 706             V11487 707
   V11488 708             V11489 709             V11490 710
   V11491 711             V11492 712             V11493 713
   V11494 714             V11495 715             V11496 716
   V11497 717             V11498 718             V11499 719
   V11500 720             V11501 721             V11502 722
   V11503 723             V11504 724             V11505 725
   V11506 726             V11507 727             V11508 728
   V11509 729             V11510 730             V11511 731
   V11512 732             V11513 733             V11514 734
   V11515 735             V11516 736             V11517 737
   V11518 738             V11519 739             V11520 740
   V11521 741             V11522 742             V11523 743
   V11524 744             V11525 745             V11526 746
   V11527 747             V11528 748             V11529 749
   V11530 750             V11531 751             V11532 752
   V11533 753             V11534 754             V11535 755-756
   V11536 757-758         V11537 759-763         V11538 764-765
   V11539 766             V11540 767-768         V11541 769-770
   V11542 771-775         V11543 776-777         V11544 778
   V11545 779-780         V11546 781-782         V11547 783-787
   V11548 788-789         V11549 790             V11550 791-792
   V11551 793-794         V11552 795-799         V11553 800-801
   V11554 802             V11555 803-804         V11556 805-806
   V11557 807-811         V11558 812-813         V11559 814
   V11560 815-818         V11561 819-824         V11562 825
   V11563 826-830         V11564 831             V11565 832-836
   V11566 837-841         V11567 842-846         V11568 847-851
   V11569 852-856         V11570 857-861         V11571 862-866
   V11572 867-871         V11573 872-876         V11574 877-881
   V11575 882-886         V11576 887-891         V11577 892-896
   V11578 897             V11579 898             V11580 899
   V11581 900-903         V11582 904-907         V11583 908-911
   V11584 912-915         V11585 916-919         V11586 920-923
   V11587 924-927         V11588 928-931         V11589 932-935
   V11590 936-939         V11591 940-943         V11592 944-947
   V11593 948-951         V11594 952-955         V11595 956-959
   V11596 960-963         V11597 964-967         V11598 968-971
   V11599 972-974         V11600 975-978         V11601 979-981
   V11602 982-984         V11603 985-988         V11604 989-991
   V11605 992-993         V11606 994-995         V11607 996
   V11608 997-998         V11609 999-1000        V11610 1001-1002
   V11611 1003-1004       V11612 1005            V11613 1006
   V11614 1007-1008       V11615 1009-1010       V11616 1011-1012
   V11617 1013            V11618 1014            V11619 1015
   V11620 1016-1017       V11621 1018            V11622 1019
   V11623 1020            V11624 1021            V11625 1022
   V11626 1023            V11627 1024            V11628 1025
   V11629 1026-1027       V11630 1028            V11631 1029
   V11632 1030            V11633 1031            V11634 1032
   V11635 1033            V11636 1034-1038       V11637 1039
   V11638 1040-1041       V11639 1042            V11640 1043
   V11641 1044            V11642 1045            V11643 1046-1047
   V11644 1048            V11645 1049-1050       V11646 1051
   V11647 1052            V11648 1053            V11649 1054
   V11650 1055            V11651 1056-1058       V11652 1059-1061
   V11653 1062            V11654 1063-1066       V11655 1067
   V11656 1068-1071       V11657 1072-1075       V11658 1076-1079
   V11659 1080            V11660 1081-1084       V11661 1085-1086
   V11662 1087            V11663 1088            V11664 1089
   V11665 1090-1091       V11666 1092            V11667 1093
   V11668 1094-1096       V11669 1097-1099       V11670 1100-1101
   V11671 1102-1103       V11672 1104            V11673 1105-1108
   V11674 1109-1110       V11675 1111            V11676 1112
   V11677 1113            V11678 1114            V11679 1115
   V11680 1116-1117       V11681 1118-1119       V11682 1120
   V11683 1121-1123       V11684 1124-1126       V11685 1127-1130
   V11686 1131-1132       V11687 1133-1134       V11688 1135-1136
   V11689 1137            V11690 1138-1141       V11691 1142-1143
   V11692 1144-1145       V11693 1146            V11694 1147-1148
   V11695 1149            V11696 1150-1151       V11697 1152
   V11698 1153-1154       V11699 1155            V11700 1156-1157
   V11701 1158            V11702 1159-1160       V11703 1161
   V11704 1162-1163       V11705 1164-1165       V11706 1166-1167
   V11707 1168            V11708 1169            V11709 1170
   V11710 1171-1172       V11711 1173-1176       V11712 1177-1178
   V11713 1179-1180       V11714 1181-1182       V11715 1183-1186
   V11716 1187-1188       V11717 1189-1190       V11718 1191
   V11719 1192-1193       V11720 1194            V11721 1195-1196
   V11722 1197-1198       V11723 1199-1200       V11724 1201
   V11725 1202            V11726 1203-1204       V11727 1205-1206
   V11728 1207-1208       V11729 1209-1210       V11730 1211-1212
   V11731 1213-1214       V11732 1215            V11733 1216-1219
   V11734 1220            V11735 1221            V11736 1222
   V11737 1223            V11738 1224            V11739 1225-1226
   V11740 1227-1228       V11741 1229-1230       V11742 1231
   V11743 1232            V11744 1233            V11745 1234-1235
   V11746 1236            V11747 1237-1240       V11748 1241-1242
   V11749 1243            V11750 1244-1245       V11751 1246
   V11752 1247-1248       V11753 1249-1250       V11754 1251
   V11755 1252-1253       V11756 1254            V11757 1255-1256
   V11758 1257-1259       V11759 1260-1262       V11760 1263
   V11761 1264            V11762 1265-1266       V11763 1267
   V11764 1268            V11765 1269-1270       V11766 1271-1272
   V11767 1273-1276       V11768 1277-1278       V11769 1279-1280
   V11770 1281-1282       V11771 1283            V11772 1284-1287
   V11773 1288-1289       V11774 1290            V11775 1291
   V11776 1292            V11777 1293-1294       V11778 1295-1296
   V11779 1297            V11780 1298-1300       V11781 1301-1303
   V11782 1304-1307       V11783 1308-1309       V11784 1310-1311
   V11785 1312-1313       V11786 1314            V11787 1315-1318
   V11788 1319-1320       V11789 1321-1322       V11790 1323
   V11791 1324-1325       V11792 1326            V11793 1327-1328
   V11794 1329            V11795 1330-1331       V11796 1332
   V11797 1333-1334       V11798 1335            V11799 1336-1337
   V11800 1338            V11801 1339-1340       V11802 1341-1342
   V11803 1343-1344       V11804 1345            V11805 1346
   V11806 1347-1348       V11807 1349-1352       V11808 1353-1354
   V11809 1355-1356       V11810 1357-1358       V11811 1359-1362
   V11812 1363-1364       V11813 1365-1366       V11814 1367
   V11815 1368-1369       V11816 1370            V11817 1371-1372
   V11818 1373-1374       V11819 1375-1376       V11820 1377
   V11821 1378            V11822 1379-1380       V11823 1381-1382
   V11824 1383-1384       V11825 1385-1386       V11826 1387-1388
   V11827 1389-1390       V11828 1391-1392       V11829 1393-1394
   V11830 1395-1396       V11831 1397            V11832 1398
   V11833 1399-1400       V11834 1401            V11835 1402-1403
   V11836 1404-1405       V11837 1406-1407       V11838 1408-1409
   V11839 1410-1411       V11840 1412-1413       V11841 1414-1415
   V11842 1416-1417       V11843 1418            V11844 1419-1420
   V11845 1421            V11846 1422            V11847 1423
   V11848 1424            V11849 1425-1426       V11850 1427-1428
   V11851 1429-1430       V11852 1431-1432       V11853 1433
   V11854 1434            V11855 1435-1436       V11856 1437-1438
   V11857 1439            V11858 1440-1441       V11859 1442-1443
   V11860 1444            V11861 1445            V11862 1446-1447
   V11863 1448-1449       V11864 1450            V11865 1451
   V11866 1452            V11867 1453            V11868 1454
   V11869 1455            V11870 1456            V11871 1457-1458
   V11872 1459            V11873 1460            V11874 1461
   V11875 1462            V11876 1463            V11877 1464
   V11878 1465            V11879 1466-1467       V11880 1468
   V11881 1469-1470       V11882 1471-1472       V11883 1473
   V11884 1474-1475       V11885 1476-1477       V11886 1478
   V11887 1479-1484       V11888 1485            V11889 1486-1487
   V11890 1488            V11891 1489            V11892 1490
   V11893 1491            V11894 1492-1497       V11895 1498
   V11896 1499            V11897 1500            V11898 1501-1502
   V11899 1503-1504       V11900 1505-1506       V11901 1507
   V11902 1508            V11903 1509            V11904 1510
   V11905 1511            V11906 1512            V11907 1513-1514
   V11908 1515-1517       V11909 1518-1519       V11910 1520-1522
   V11911 1523            V11912 1524            V11913 1525
   V11914 1526            V11915 1527-1528       V11916 1529-1531
   V11917 1532            V11918 1533            V11919 1534
   V11920 1535            V11921 1536            V11922 1537
   V11923 1538            V11924 1539            V11925 1540-1541
   V11926 1542            V11927 1543            V11928 1544-1545
   V11929 1546            V11930 1547            V11931 1548-1549
   V11932 1550            V11933 1551            V11934 1552-1553
   V11935 1554            V11936 1555            V11937 1556
   V11938 1557            V11939 1558            V11940 1559
   V11941 1560-1561       V11942 1562-1563       V11943 1564-1565
   V11944 1566-1567       V11945 1568            V11946 1569-1570
   V11947 1571-1572       V11948 1573-1574       V11949 1575-1576
   V11950 1577-1578       V11951 1579-1580       V11952 1581-1582
   V11953 1583-1584       V11954 1585-1586       V11955 1587-1588
   V11956 1589            V11957 1590-1591       V11958 1592-1593
   V11959 1594            V11960 1595            V11961 1596-1597
   V11962 1598-1599       V11963 1600-1601       V11964 1602
   V11965 1603            V11966 1604            V11967 1605-1606
   V11968 1607-1608       V11969 1609-1610       V11970 1611-1612
   V11971 1613            V11972 1614-1615       V11973 1616-1617
   V11974 1618-1619       V11975 1620-1621       V11976 1622
   V11977 1623-1624       V11978 1625-1626       V11979 1627-1628
   V11980 1629-1630       V11981 1631-1632       V11982 1633-1634
   V11983 1635            V11984 1636            V11985 1637
   V11986 1638-1639       V11987 1640-1641       V11988 1642-1643
   V11989 1644            V11990 1645-1649       V11991 1650
   V11992 1651            V11993 1652            V11994 1653
   V11995 1654            V11996 1655-1657       V11997 1658
   V11998 1659            V11999 1660            V12000 1661
   V12001 1662-1663       V12002 1664            V12003 1665
   V12004 1666            V12005 1667            V12006 1668-1669
   V12007 1670            V12008 1671-1672       V12009 1673
   V12010 1674            V12011 1675            V12012 1676
   V12013 1677            V12014 1678-1680       V12015 1681-1683
   V12016 1684            V12017 1685-1688       V12018 1689
   V12019 1690-1693       V12020 1694-1697       V12021 1698-1701
   V12022 1702            V12023 1703-1706       V12024 1707-1708
   V12025 1709            V12026 1710            V12027 1711
   V12028 1712-1713       V12029 1714            V12030 1715
   V12031 1716-1718       V12032 1719-1721       V12033 1722-1723
   V12034 1724-1725       V12035 1726            V12036 1727-1730
   V12037 1731-1732       V12038 1733            V12039 1734
   V12040 1735            V12041 1736            V12042 1737
   V12043 1738-1739       V12044 1740-1741       V12045 1742
   V12046 1743-1745       V12047 1746-1748       V12048 1749-1752
   V12049 1753-1754       V12050 1755-1756       V12051 1757-1758
   V12052 1759            V12053 1760-1763       V12054 1764-1765
   V12055 1766-1767       V12056 1768            V12057 1769-1770
   V12058 1771            V12059 1772-1773       V12060 1774
   V12061 1775-1776       V12062 1777            V12063 1778-1779
   V12064 1780            V12065 1781-1782       V12066 1783
   V12067 1784-1785       V12068 1786-1787       V12069 1788-1789
   V12070 1790            V12071 1791            V12072 1792
   V12073 1793-1794       V12074 1795-1798       V12075 1799-1800
   V12076 1801-1802       V12077 1803-1804       V12078 1805-1808
   V12079 1809-1810       V12080 1811-1812       V12081 1813
   V12082 1814-1815       V12083 1816            V12084 1817-1818
   V12085 1819-1820       V12086 1821-1822       V12087 1823
   V12088 1824            V12089 1825-1826       V12090 1827-1828
   V12091 1829-1830       V12092 1831-1832       V12093 1833-1834
   V12094 1835-1836       V12095 1837            V12096 1838-1841
   V12097 1842            V12098 1843            V12099 1844
   V12100 1845            V12101 1846            V12102 1847-1848
   V12103 1849-1850       V12104 1851-1852       V12105 1853
   V12106 1854            V12107 1855            V12108 1856-1857
   V12109 1858            V12110 1859-1862       V12111 1863-1864
   V12112 1865            V12113 1866-1867       V12114 1868
   V12115 1869-1870       V12116 1871-1872       V12117 1873
   V12118 1874-1875       V12119 1876            V12120 1877-1878
   V12121 1879-1881       V12122 1882-1884       V12123 1885
   V12124 1886            V12125 1887-1888       V12126 1889
   V12127 1890            V12128 1891-1892       V12129 1893-1894
   V12130 1895-1898       V12131 1899-1900       V12132 1901-1902
   V12133 1903-1904       V12134 1905            V12135 1906-1909
   V12136 1910-1911       V12137 1912            V12138 1913
   V12139 1914            V12140 1915-1916       V12141 1917-1918
   V12142 1919            V12143 1920-1922       V12144 1923-1925
   V12145 1926-1929       V12146 1930-1931       V12147 1932-1933
   V12148 1934-1935       V12149 1936            V12150 1937-1940
   V12151 1941-1942       V12152 1943-1944       V12153 1945
   V12154 1946-1947       V12155 1948            V12156 1949-1950
   V12157 1951            V12158 1952-1953       V12159 1954
   V12160 1955-1956       V12161 1957            V12162 1958-1959
   V12163 1960            V12164 1961-1962       V12165 1963-1964
   V12166 1965-1966       V12167 1967            V12168 1968
   V12169 1969-1970       V12170 1971-1974       V12171 1975-1976
   V12172 1977-1978       V12173 1979-1980       V12174 1981-1984
   V12175 1985-1986       V12176 1987-1988       V12177 1989
   V12178 1990-1991       V12179 1992            V12180 1993-1994
   V12181 1995-1996       V12182 1997-1998       V12183 1999
   V12184 2000            V12185 2001-2002       V12186 2003-2004
   V12187 2005-2006       V12188 2007-2008       V12189 2009-2010
   V12190 2011-2012       V12191 2013-2014       V12192 2015-2016
   V12193 2017-2018       V12194 2019            V12195 2020
   V12196 2021            V12197 2022            V12198 2023-2024
   V12199 2025            V12200 2026-2027       V12201 2028-2029
   V12202 2030-2031       V12203 2032-2033       V12204 2034-2035
   V12205 2036-2037       V12206 2038-2039       V12207 2040-2041
   V12208 2042-2043       V12209 2044-2045       V12210 2046
   V12211 2047            V12212 2048            V12213 2049
   V12214 2050-2051       V12215 2052-2053       V12216 2054
   V12217 2055            V12218 2056            V12219 2057
   V12220 2058            V12221 2059            V12222 2060
   V12223 2061            V12224 2062            V12225 2063
   V12226 2064            V12227 2065-2066       V12228 2067-2068
   V12229 2069            V12230 2070            V12231 2071-2072
   V12232 2073-2074       V12233 2075            V12234 2076
   V12235 2077            V12236 2078-2079       V12237 2080-2081
   V12238 2082            V12239 2083            V12240 2084
   V12241 2085            V12242 2086            V12243 2087
   V12244 2088            V12245 2089            V12246 2090-2091
   V12247 2092            V12248 2093            V12249 2094
   V12250 2095            V12251 2096            V12252 2097
   V12253 2098            V12254 2099-2100       V12255 2101
   V12256 2102-2103       V12257 2104-2105       V12258 2106
   V12259 2107-2108       V12260 2109-2110       V12261 2111
   V12262 2112-2113       V12263 2114-2116       V12264 2117-2118
   V12265 2119-2121       V12266 2122            V12267 2123
   V12268 2124            V12269 2125            V12270 2126-2127
   V12271 2128-2130       V12272 2131            V12273 2132
   V12274 2133            V12275 2134            V12276 2135
   V12277 2136            V12278 2137            V12279 2138
   V12280 2139-2140       V12281 2141            V12282 2142
   V12283 2143-2144       V12284 2145            V12285 2146
   V12286 2147-2148       V12287 2149            V12288 2150
   V12289 2151-2152       V12290 2153            V12291 2154
   V12292 2155            V12293 2156            V12294 2157
   V12295 2158            V12296 2159-2160       V12297 2161-2162
   V12298 2163-2164       V12299 2165-2166       V12300 2167
   V12301 2168-2169       V12302 2170-2171       V12303 2172-2173
   V12304 2174-2175       V12305 2176-2177       V12306 2178-2179
   V12307 2180-2181       V12308 2182-2183       V12309 2184-2185
   V12310 2186-2187       V12311 2188            V12312 2189-2190
   V12313 2191-2192       V12314 2193            V12315 2194
   V12316 2195-2196       V12317 2197-2198       V12318 2199-2200
   V12319 2201            V12320 2202            V12321 2203
   V12322 2204-2205       V12323 2206-2207       V12324 2208-2209
   V12325 2210-2211       V12326 2212            V12327 2213-2214
   V12328 2215-2216       V12329 2217-2218       V12330 2219-2220
   V12331 2221            V12332 2222-2223       V12333 2224-2225
   V12334 2226-2227       V12335 2228-2229       V12336 2230-2231
   V12337 2232-2233       V12338 2234            V12339 2235-2236
   V12340 2237-2238       V12341 2239-2240       V12342 2241
   V12343 2242-2246       V12344 2247            V12345 2248
   V12346 2249            V12347 2250            V12348 2251
   V12349 2252-2254       V12350 2255            V12351 2256
   V12352 2257            V12353 2258-2259       V12354 2260
   V12355 2261            V12356 2262-2263       V12357 2264-2265
   V12358 2266-2270       V12359 2271-2272       V12360 2273-2276
   V12361 2277-2278       V12362 2279-2282       V12363 2283-2284
   V12364 2285-2288       V12365 2289-2290       V12366 2291-2294
   V12367 2295-2296       V12368 2297-2300       V12369 2301-2302
   V12370 2303-2307       V12371 2308-2314       V12372 2315-2320
   V12373 2321-2325 .2    V12374 2326-2330       V12375 2331-2334 .2
   V12376 2335-2338       V12377 2339-2342 .2    V12378 2343-2346 .2
   V12379 2347            V12380 2348-2349       V12381 2350-2352
   V12382 2353-2354       V12383 2355            V12384 2356
   V12385 2357            V12386 2358            V12387 2359
   V12388 2360            V12389 2361            V12390 2362
   V12391 2363            V12392 2364-2365       V12393 2366-2367
   V12394 2368-2372       V12395 2373            V12396 2374-2375 .1
   V12397 2376-2377       V12398 2378            V12399 2379
   V12400 2380            V12401 2381            V12402 2382
   V12403 2383            V12404 2384            V12405 2385
   V12406 2386            V12407 2387            V12408 2388
   V12409 2389            V12410 2390            V12411 2391
   V12412 2392            V12413 2393            V12414 2394
   V12415 2395            V12416 2396            V12417 2397
   V12418 2398-2399       V12419 2400            V12420 2401-2402
   V12421 2403-2405       V12422 2406            V12423 2407-2410
   V12424 2411-2412       V12425 2413            V12426 2414
   V12427 2415            V12428 2416            V12429 2417-2418
   V12430 2419-2420       V12431 2421            V12432 2422
   V12433 2423-2426       V12434 2427-2430       V12435 2431
   V12436 2432-2433       V12437 2434-2437       V12438 2438
   V12439 2439-2440       V12440 2441-2444       V12441 2445
   V12442 2446-2447       V12443 2448-2451       V12444 2452
   V12445 2453-2454       V12446 2455-2456;

* SAS LABEL STATEMENT;

LABEL
   V11101 = "STUDY NUMBER (713)"
   V11102 = "1985 INTERVIEW NUMBER"
   V11103 = "CURRENT STATE"
   V11104 = "CURRENT COUNTY"
   V11105 = "CURRENT STATE+CNTY"
   V11106 = "SIZE LGST CITY/SMSA   85"
   V11107 = "SPLITOFF INDICATOR    85"
   V11108 = "WHETHER HD REFUSED    85"
   V11109 = "WHETHER WF REFUSED    85"
   V11110 = "MODE OF INTERVIEW,HD  85"
   V11111 = "MODE OF INTERVIEW,WF  85"
   V11112 = "FAM COMP CHANGE       85"
   V11113 = "# MOVED IN            85"
   V11114 = "WHO MOVED IN          85"
   V11115 = "# MOVED OUT           85"
   V11116 = "WHO MOVED OUT         85"
   V11117 = "CURRENT FAM COMP      85"
   V11118 = "68 ID# OF HOUSEHOLDER 85"
   V11119 = "PERS# OF HOUSEHOLDER  85"
   V11120 = "AGE OF HOUSEHOLDER    85"
   V11121 = "SEX OF HOUSEHOLDER    85"
   V11122 = "REL HHOLDER TO FU HD  85"
   V11123 = "QUALITY OF MATCH      85"
   V11124 = "TYPE INSTITUTION      85"
   V11125 = "1985 HOUSE VALUE   (A10)"
   V11126 = "ACC 85 HOUSE VALUE"
   V11127 = "1985 REM MORT PRIN (A12)"
   V11128 = "ACC REM MORT PRIN"
   V11129 = "1985 ANN MORT PMNT (A14)"
   V11130 = "ACC ANN MORT PAYMENT"
   V11131 = "ANN PROPERTY TAX 85(A18)"
   V11132 = "ACC ANN PROPERTY TX   85"
   V11133 = "ANN RENT 1985      (A20)"
   V11134 = "ACC ANN RENT 85"
   V11135 = "ANN VALUE IF RENTED(A26)"
   V11136 = "ACC ANN VALUE IF RENTED"
   V11137 = "ANN UTILITIES         85"
   V11138 = "ACC ANN UTIL          85"
   V11139 = "GOVT SUBSIDY OF HTG (A8)"
   V11140 = "HD MAIN JOB WRKHRS 84"
   V11141 = "ACC HD 84 MAIN JOB WRKHR"
   V11142 = "HD OVERTIME WRKHRS 84"
   V11143 = "ACC HD 84 OVERTIME WRKHR"
   V11144 = "HD XTRA JOB WRKHRS 84"
   V11145 = "ACC HD 84 XTRA JOB WRKHR"
   V11146 = "HD ANN WRK HRS IN 84"
   V11147 = "HD HRS WRK LOST OTR ILL"
   V11148 = "ACC HD HR LOST OTR ILL"
   V11149 = "HD HRS WRK LOST OWN ILL"
   V11150 = "ACC HD HRS LOST OWN ILL"
   V11151 = "HD STRIKE HOURS 84"
   V11152 = "ACC HD STRIKE HRS 84"
   V11153 = "HD UNEMP HRS 84"
   V11154 = "ACC 84 HD UNEMP HRS"
   V11155 = "HD HRS OUT LBR FORCE 84"
   V11156 = "ACC 84 HD HR OUT LBR FRC"
   V11157 = "HD HRS TRAVEL TO WORK 84"
   V11158 = "ACC HD TRAVEL TO WORK"
   V11159 = "HD WRKD/EMPLOYER JAN 84"
   V11160 = "HD WRKD/EMPLOYER FEB 84"
   V11161 = "HD WRKD/EMPLOYER MAR 84"
   V11162 = "HD WRKD/EMPLOYER APR 84"
   V11163 = "HD WRKD/EMPLOYER MAY 84"
   V11164 = "HD WRKD/EMPLOYER JUN 84"
   V11165 = "HD WRKD/EMPLOYER JUL 84"
   V11166 = "HD WRKD/EMPLOYER AUG 84"
   V11167 = "HD WRKD/EMPLOYER SEP 84"
   V11168 = "HD WRKD/EMPLOYER OCT 84"
   V11169 = "HD WRKD/EMPLOYER NOV 84"
   V11170 = "HD WRKD/EMPLOYER DEC 84"
   V11171 = "HD WRKD/EMPLOYER JAN 85"
   V11172 = "HD WRKD/EMPLOYER FEB 85"
   V11173 = "HD WRKD/EMPLOYER MAR 85"
   V11174 = "HD WRKD/EMPLOYER APR 85"
   V11175 = "HD WRKD/EMPLOYER MAY 85"
   V11176 = "HD WRKD/EMPLOYER JUN 85"
   V11177 = "HD WRKD/EMPLOYER JUL 85"
   V11178 = "HD WRKD/EMPLOYER AUG 85"
   V11179 = "HD WRKD/EMPLOYER SEP 85"
   V11180 = "HD WRKD/EMPLOYER OCT 85"
   V11181 = "HD WRK/EMPR QUALITY CODE"
   V11182 = "HD START/END POS JAN 84"
   V11183 = "HD START/END POS FEB 84"
   V11184 = "HD START/END POS MAR 84"
   V11185 = "HD START/END POS APR 84"
   V11186 = "HD START/END POS MAY 84"
   V11187 = "HD START/END POS JUN 84"
   V11188 = "HD START/END POS JUL 84"
   V11189 = "HD START/END POS AUG 84"
   V11190 = "HD START/END POS SEP 84"
   V11191 = "HD START/END POS OCT 84"
   V11192 = "HD START/END POS NOV 84"
   V11193 = "HD START/END POS DEC 84"
   V11194 = "HD START/END POS JAN 85"
   V11195 = "HD START/END POS FEB 85"
   V11196 = "HD START/END POS MAR 85"
   V11197 = "HD START/END POS APR 85"
   V11198 = "HD START/END POS MAY 85"
   V11199 = "HD START/END POS JUN 85"
   V11200 = "HD START/END POS JUL 85"
   V11201 = "HD START/END POS AUG 85"
   V11202 = "HD START/END POS SEP 85"
   V11203 = "HD START/END POS OCT 85"
   V11204 = "HD STRT/END QUALITY CODE"
   V11205 = "HD UNEMP/OUT LBR JAN 84"
   V11206 = "HD UNEMP/OUT LBR FEB 84"
   V11207 = "HD UNEMP/OUT LBR MAR 84"
   V11208 = "HD UNEMP/OUT LBR APR 84"
   V11209 = "HD UNEMP/OUT LBR MAY 84"
   V11210 = "HD UNEMP/OUT LBR JUN 84"
   V11211 = "HD UNEMP/OUT LBR JUL 84"
   V11212 = "HD UNEMP/OUT LBR AUG 84"
   V11213 = "HD UNEMP/OUT LBR SEP 84"
   V11214 = "HD UNEMP/OUT LBR OCT 84"
   V11215 = "HD UNEMP/OUT LBR NOV 84"
   V11216 = "HD UNEMP/OUT LBR DEC 84"
   V11217 = "HD UNEMP/OUT LBR JAN 85"
   V11218 = "HD UNEMP/OUT LBR FEB 85"
   V11219 = "HD UNEMP/OUT LBR MAR 85"
   V11220 = "HD UNEMP/OUT LBR APR 85"
   V11221 = "HD UNEMP/OUT LBR MAY 85"
   V11222 = "HD UNEMP/OUT LBR JUN 85"
   V11223 = "HD UNEMP/OUT LBR JUL 85"
   V11224 = "HD UNEMP/OUT LBR AUG 85"
   V11225 = "HD UNEMP/OUT LBR SEP 85"
   V11226 = "HD UNEMP/OUT LBR OCT 85"
   V11227 = "HD UNEMPLYD QUALITY CODE"
   V11228 = "HD XTRA JOBS JAN 84"
   V11229 = "HD XTRA JOBS FEB 84"
   V11230 = "HD XTRA JOBS MAR 84"
   V11231 = "HD XTRA JOBS APR 84"
   V11232 = "HD XTRA JOBS MAY 84"
   V11233 = "HD XTRA JOBS JUN 84"
   V11234 = "HD XTRA JOBS JUL 84"
   V11235 = "HD XTRA JOBS AUG 84"
   V11236 = "HD XTRA JOBS SEP 84"
   V11237 = "HD XTRA JOBS OCT 84"
   V11238 = "HD XTRA JOBS NOV 84"
   V11239 = "HD XTRA JOBS DEC 84"
   V11240 = "HD XTRA JOBS JAN 85"
   V11241 = "HD XTRA JOBS FEB 85"
   V11242 = "HD XTRA JOBS MAR 85"
   V11243 = "HD XTRA JOBS APR 85"
   V11244 = "HD XTRA JOBS MAY 85"
   V11245 = "HD XTRA JOBS JUN 85"
   V11246 = "HD XTRA JOBS JUL 85"
   V11247 = "HD XTRA JOBS AUG 8S"
   V11248 = "HD XTRA JOBS SEP 85"
   V11249 = "HD XTRA JOBS OCT 85"
   V11250 = "HD XTRA JOB QUALITY CODE"
   V11251 = "WIFE IN FU?"
   V11252 = "WF MAIN JOB WRKHRS 84"
   V11253 = "ACC WF 84 MAIN JOB WRKHR"
   V11254 = "WF OVERTIME WRKHRS 84"
   V11255 = "ACC WF 84 OVERTIME WRKHR"
   V11256 = "WF XTRA JOB WRKHRS 84"
   V11257 = "ACC WF 84 XTRA JOB WRKHR"
   V11258 = "WF ANN WRK HRS IN 84"
   V11259 = "WF HRS WRK LOST OTR ILL"
   V11260 = "ACC WF HR LOST OTR ILL"
   V11261 = "WF HRS WRK LOST OWN ILL"
   V11262 = "ACC WF HRS LOST OWN ILL"
   V11263 = "WF STRIKE HOURS 84"
   V11264 = "ACC WF STRIKE HRS 84"
   V11265 = "WF UNEMP HRS 84"
   V11266 = "ACC WF UNEMP HRS 84"
   V11267 = "WF HRS OUT LBR FORCE 84"
   V11268 = "ACC WF 84 HR OUT LBR FRC"
   V11269 = "WF HRS TRAVEL TO WORK 84"
   V11270 = "ACC WF TRAVEL TO WORK"
   V11271 = "WF WRK/EMPLOYER JAN 84"
   V11272 = "WF WRK/EMPLOYER FEB 84"
   V11273 = "WF WRK/EMPLOYER MAR 84"
   V11274 = "WF WRK/EMPLOYER APR 84"
   V11275 = "WF WRK/EMPLOYER MAY 84"
   V11276 = "WF WRK/EMPLOYER JUN 84"
   V11277 = "WF WRK/EMPLOYER JUL 84"
   V11278 = "WF WRK/EMPLOYER AUG 84"
   V11279 = "WF WRK/EMPLOYER SEP 84"
   V11280 = "WF WRK/EMPLOYER OCT 84"
   V11281 = "WF WRK/EMPLOYER NOV 84"
   V11282 = "WF WRK/EMPLOYER DEC 84"
   V11283 = "WF WRK/EMPLOYER JAN 85"
   V11284 = "WF WRK/EMPLOYER FEB 85"
   V11285 = "WF WRK/EMPLOYER MAR 85"
   V11286 = "WF WRK/EMPLOYER APR 85"
   V11287 = "WF WRK/EMPLOYER MAY 85"
   V11288 = "WF WRK/EMPLOYER JUN 85"
   V11289 = "WF WRK/EMPLOYER JUL 85"
   V11290 = "WF WRK/EMPLOYER AUG 85"
   V11291 = "WF WRK/EMPLOYER SEP 85"
   V11292 = "WF WRK/EMPLOYER OCT 85"
   V11293 = "WF WRK/EMPR QUALITY CODE"
   V11294 = "WF START/END POS JAN 84"
   V11295 = "WF START/END POS FEB 84"
   V11296 = "WF START/END POS MAR 84"
   V11297 = "WF START/END POS APR 84"
   V11298 = "WF START/END POS MAY 84"
   V11299 = "WF START/END POS JUN 84"
   V11300 = "WF START/END POS JUL 84"
   V11301 = "WF START/END POS AUG 84"
   V11302 = "WF START/END POS SEP 84"
   V11303 = "WF START/END POS OCT 84"
   V11304 = "WF START/END POS NOV 84"
   V11305 = "WF START/END POS DEC 84"
   V11306 = "WF START/END POS JAN 85"
   V11307 = "WF START/END POS FEB 85"
   V11308 = "WF START/END POS MAR 85"
   V11309 = "WF START/END POS APR 85"
   V11310 = "WF START/END POS MAY 85"
   V11311 = "WF START/END POS JUN 85"
   V11312 = "WF START/END POS JUL 85"
   V11313 = "WF START/END POS AUG 85"
   V11314 = "WF START/END POS SEP 85"
   V11315 = "WF START/END POS OCT 85"
   V11316 = "WF STRT/END QUALITY CODE"
   V11317 = "WF UNEMP/OUT LBR JAN 84"
   V11318 = "WF UNEMP/OUT LBR FEB 84"
   V11319 = "WF UNEMP/OUT LBR MAR 84"
   V11320 = "WF UNEMP/OUT LBR APR 84"
   V11321 = "WF UNEMP/OUT LBR MAY 84"
   V11322 = "WF UNEMP/OUT LBR JUN 84"
   V11323 = "WF UNEMP/OUT LBR JUL 84"
   V11324 = "WF UNEMP/OUT LBR AUG 84"
   V11325 = "WF UNEMP/OUT LBR SEP 84"
   V11326 = "WF UNEMP/OUT LBR OCT 84"
   V11327 = "WF UNEMP/OUT LBR NOV 84"
   V11328 = "WF UNEMP/OUT LBR DEC 84"
   V11329 = "WF UNEMP/OUT LBR JAN 85"
   V11330 = "WF UNEMP/OUT LBR FEB 85"
   V11331 = "WF UNEMP/OUT LBR MAR 85"
   V11332 = "WF UNEMP/OUT LBR APR 85"
   V11333 = "WF UNEMP/OUT LBR MAY 85"
   V11334 = "WF UNEMP/OUT LBR JUN 85"
   V11335 = "WF UNEMP/OUT LBR JUL 85"
   V11336 = "WF UNEMP/OUT LBR AUG 85"
   V11337 = "WF UNEMP/OUT LBR SEP 85"
   V11338 = "WF UNEMP/OUT LBR OCT 85"
   V11339 = "WF UNEMPLYD QUALITY CODE"
   V11340 = "WF XTRA JOBS JAN 84"
   V11341 = "WF XTRA JOBS FEB 84"
   V11342 = "WF XTRA JOBS MAR 84"
   V11343 = "WF XTRA JOBS APR 84"
   V11344 = "WF XTRA JOBS MAY 84"
   V11345 = "WF XTRA JOBS JUN 84"
   V11346 = "WF XTRA JOBS JUL 84"
   V11347 = "WF XTRA JOBS AUG 84"
   V11348 = "WF XTRA JOBS SEP 84"
   V11349 = "WF XTRA JOBS OCT 84"
   V11350 = "WF XTRA JOBS NOV 84"
   V11351 = "WF XTRA JOBS DEC 84"
   V11352 = "WF XTRA JOBS JAN 85"
   V11353 = "WF XTRA JOBS FEB 85"
   V11354 = "WF XTRA JOBS MAR 85"
   V11355 = "WF XTRA JOBS APR 85"
   V11356 = "WF XTRA JOBS MAY 85"
   V11357 = "WF XTRA JOBS JUN 85"
   V11358 = "WF XTRA JOBS JUL 85"
   V11359 = "WF XTRA JOBS AUG 85"
   V11360 = "WF XTRA JOBS SEP 85"
   V11361 = "WF XTRA JOBS OCT 85"
   V11362 = "WF XTRA JOB QUALITY CODE"
   V11363 = "# MAJOR ADULTS"
   V11364 = "1985 FAMILY SIZE"
   V11365 = "# REQUIRED ROOMS"
   V11366 = "WIFE ANN HOUSEWORK  (P1)"
   V11367 = "ACC WIFE ANN HOUSEWORK"
   V11368 = "HEAD ANN HOUSEWORK  (H1)"
   V11369 = "ACC HEAD ANN HOUSEWORK"
   V11370 = "OTHER ANN HOUSEWORK (H5)"
   V11371 = "ACC OTHER ANN HOUSEWORK"
   V11372 = "# PERSONS GOT FOOD STAMP"
   V11373 = "VALUE FD ST LAST MO (H9)"
   V11374 = "ACC VALUE FD ST LAST MO"
   V11375 = "ANN FOOD COST EXC FD ST"
   V11376 = "ACC ANN FOOD COST"
   V11377 = "ANN EAT OUT COST(H14/18)"
   V11378 = "ACC ANN EAT OUT COST"
   V11379 = "VALUE FD ST 84     (H20)"
   V11380 = "ACC VALUE FD ST 84"
   V11381 = "# MOS USED FD ST 84(H21)"
   V11382 = "WTR USED FD ST JAN 84"
   V11383 = "WTR USED FD ST FEB 84"
   V11384 = "WTR USED FD ST MAR 84"
   V11385 = "WTR USED FD ST APR 84"
   V11386 = "WTR USED FD ST MAY 84"
   V11387 = "WTR USED FD ST JUN 84"
   V11388 = "WTR USED FD ST JUL 84"
   V11389 = "WTR USED FD ST AUG 84"
   V11390 = "WTR USED FD ST SEP 84"
   V11391 = "WTR USED FD ST OCT 84"
   V11392 = "WTR USED FD ST NOV 84"
   V11393 = "WTR USED FD ST DEC 84"
   V11394 = "HD/WF HAVE TXBL Y?"
   V11395 = "LABOR PART FARM Y 84"
   V11396 = "LABOR PART BUS Y 84"
   V11397 = "HEAD 84 WAGES"
   V11398 = "ACC HEAD 84 WAGES"
   V11399 = "HD BONUS/OT/COMM 84"
   V11400 = "HD PROF PRAC/TRADE 84"
   V11401 = "LABOR PT MKT GARDEN 84"
   V11402 = "LABOR PT ROOMERS 84"
   V11403 = "ACC HD LABOR Y EXC WAGES"
   V11404 = "WIFE 84 LABOR/WAGE"
   V11405 = "ACC WF 84 LABOR/WAGE"
   V11406 = "ASSET PART FARM Y 84"
   V11407 = "ASSET PART BUS Y 84"
   V11408 = "ASSET PT MKT GARDN 84"
   V11409 = "ASSET PT ROOMERS 84"
   V11410 = "WF PT ASSET INCOME 84"
   V11411 = "HD # MO RECD RENT 84"
   V11412 = "HD RENT 84"
   V11413 = "HD # MO RECD INT/DIV 84"
   V11414 = "HD INT/DIVIDENDS 84"
   V11415 = "HD #MO RECD ALIMONY 84"
   V11416 = "ALIMONY Y HEAD 84"
   V11417 = "WF 84 OTHER ASSET Y"
   V11418 = "ACC H+W 84 ASSET Y"
   V11419 = "H+W 84 TAXABLE Y"
   V11420 = "H+W 84 SUPP OTR NONFU"
   V11421 = "CHILD SUPPORT PAID 84"
   V11422 = "ALIMONY PAID 84"
   V11423 = "H+W 84 # DEPENDENTS"
   V11424 = "H+W TOTAL 84 EXEMPTION"
   V11425 = "1984 TAX TABLE USED-H+W"
   V11426 = "HD/WF REC TRANSFER Y 84?"
   V11427 = "H+W 84 ADC/AFDC"
   V11428 = "ACC H+W 84 ADC/AFDC"
   V11429 = "H+W # MO RECEIVE SSI 84"
   V11430 = "H+W 84 SSI"
   V11431 = "H+W 84 OTR WELFARE"
   V11432 = "H+W #MO RECD SOC SEC 84"
   V11433 = "H+W 84 SOCIAL SECURITY"
   V11434 = "H+W TYPE SOC SEC 84"
   V11435 = "HD #MO REC VA PENSION 84"
   V11436 = "HD 84 VA PENSION"
   V11437 = "HD #MO RECD OTR RET 84"
   V11438 = "HD OTHER RETIREMENT 84"
   V11439 = "HD # OTH PENS RCD 84"
   V11440 = "HD 84 UNEMP COMP"
   V11441 = "HD 84 WORKERS COMP"
   V11442 = "HD #MO REC CHILD SUPP 84"
   V11443 = "HD 84 CHILD SUPPORT"
   V11444 = "HD #MO REC HLP FR REL 84"
   V11445 = "HD 84 HELP FROM RELS"
   V11446 = "HD #MO REC OTR TRAN Y 84"
   V11447 = "HD 84 OTHER TRANSFER Y"
   V11448 = "WF #MO REC VA PENSION 84"
   V11449 = "WF 84 VA PENSION"
   V11450 = "WF #MO RECD OTR RET 84"
   V11451 = "WF OTHER RETIREMENT 84"
   V11452 = "WF 84 UNEMP COMP"
   V11453 = "WF 84 WORKERS COMP"
   V11454 = "WF #MO REC CHILD SUPP 84"
   V11455 = "WF 84 CHILD SUPPORT"
   V11456 = "WF #MO REC HLP FR REL 84"
   V11457 = "WF 84 HELP FROM RELS"
   V11458 = "WF #MO REC OTR TRAN Y 84"
   V11459 = "WF 84 OTHER TRANSFER Y"
   V11460 = "ACC H+W 84 TRANS EXC ADC"
   V11461 = "H+W 84 TOT TRANSFER Y"
   V11462 = "H+W RECD ADC/AFDC JAN 84"
   V11463 = "H+W RECD ADC/AFDC FEB 84"
   V11464 = "H+W RECD ADC/AFDC MAR 84"
   V11465 = "H+W RECD ADC/AFDC APR 84"
   V11466 = "H+W RECD ADC/AFDC MAY 84"
   V11467 = "H+W RECD ADC/AFDC JUN 84"
   V11468 = "H+W RECD ADC/AFDC JUL 84"
   V11469 = "H+W RECD ADC/AFDC AUG 84"
   V11470 = "H+W RECD ADC/AFDC SEP 84"
   V11471 = "H+W RECD ADC/AFDC OCT 84"
   V11472 = "H+W RECD ADC/AFDC NOV 84"
   V11473 = "H+W RECD ADC/AFDC DEC 84"
   V11474 = "H+W REC OTR WELFR JAN 84"
   V11475 = "H+W REC OTR WELFR FEB 84"
   V11476 = "H+W REC OTR WELFR MAR 84"
   V11477 = "H+W REC OTR WELFR APR 84"
   V11478 = "H+W REC OTR WELFR MAY 84"
   V11479 = "H+W REC OTR WELFR JUN 84"
   V11480 = "H+W REC OTR WELFR JUL 84"
   V11481 = "H+W REC OTR WELFR AUG 84"
   V11482 = "H+W REC OTR WELFR SEP 84"
   V11483 = "H+W REC OTR WELFR OCT 84"
   V11484 = "H+W REC OTR WELFR NOV 84"
   V11485 = "H+W REC OTR WELFR DEC 84"
   V11486 = "HD REC UNEMP COMP JAN 84"
   V11487 = "HD REC UNEMP COMP FEB 84"
   V11488 = "HD REC UNEMP COMP MAR 84"
   V11489 = "HD REC UNEMP COMP APR 84"
   V11490 = "HD REC UNEMP COMP MAY 84"
   V11491 = "HD REC UNEMP COMP JUN 84"
   V11492 = "HD REC UNEMP COMP JUL 84"
   V11493 = "HD REC UNEMP COMP AUG 84"
   V11494 = "HD REC UNEMP COMP SEP 84"
   V11495 = "HD REC UNEMP COMP OCT 84"
   V11496 = "HD REC UNEMP COMP NOV 84"
   V11497 = "HD REC UNEMP COMP DEC 84"
   V11498 = "WF REC UNEMP COMP JAN 84"
   V11499 = "WF REC UNEMP COMP FEB 84"
   V11500 = "WF REC UNEMP COMP MAR 84"
   V11501 = "WF REC UNEMP COMP APR 84"
   V11502 = "WF REC UNEMP COMP MAY 84"
   V11503 = "WF REC UNEMP COMP JUN 84"
   V11504 = "WF REC UNEMP COMP JUL 84"
   V11505 = "WF REC UNEMP COMP AUG 84"
   V11506 = "WF REC UNEMP COMP SEP 84"
   V11507 = "WF REC UNEMP COMP OCT 84"
   V11508 = "WF REC UNEMP COMP NOV 84"
   V11509 = "WF REC UNEMP COMP DEC 84"
   V11510 = "HD REC WORKR COMP JAN 84"
   V11511 = "HD REC WORKR COMP FEB 84"
   V11512 = "HD REC WORKR COMP MAR 84"
   V11513 = "HD REC WORKR COMP APR 84"
   V11514 = "HD REC WORKR COMP MAY 84"
   V11515 = "HD REC WORKR COMP JUN 84"
   V11516 = "HD REC WORKR COMP JUL 84"
   V11517 = "HD REC WORKR COMP AUG 84"
   V11518 = "HD REC WORKR COMP SEP 84"
   V11519 = "HD REC WORKR COMP OCT 84"
   V11520 = "HD REC WORKR COMP NOV 84"
   V11521 = "HD REC WORKR COMP DEC 84"
   V11522 = "WF REC WRKR COMP JAN 84"
   V11523 = "WF REC WRKR COMP FEB 84"
   V11524 = "WF REC WRKR COMP MAR 84"
   V11525 = "WF REC WRKR COMP APR 84"
   V11526 = "WF REC WRKR COMP MAY 84"
   V11527 = "WF REC WRKR COMP JUN 84"
   V11528 = "WF REC WRKR COMP JUL 84"
   V11529 = "WF REC WRKR COMP AUG 84"
   V11530 = "WF REC WRKR COMP SEP 84"
   V11531 = "WF REC WRKR COMP OCT 84"
   V11532 = "WF REC WRKR COMP NOV 84"
   V11533 = "WF REC WRKR COMP DEC 84"
   V11534 = "OFUM REC TXBL Y 84?"
   V11535 = "SEQ# 1ST OFUM W TXBL Y"
   V11536 = "P PRORAT TXBL Y 1ST OFUM"
   V11537 = "TXBL Y 1ST XTRA EARNER"
   V11538 = "# EXEMP 1ST XTRA EARNER"
   V11539 = "TAX TABLE 1ST XTRA EARNR"
   V11540 = "SEQ# 2ND OFUM W TXBL Y"
   V11541 = "P PRORAT TXBL Y 2ND OFUM"
   V11542 = "TXBL Y 2ND XTRA EARNER"
   V11543 = "# EXEMP 2ND XTRA EARNER"
   V11544 = "TAX TABLE 2ND XTRA EARNR"
   V11545 = "SEQ# 3RD OFUM W TXBL Y"
   V11546 = "P PRORAT TXBL Y 3RD OFUM"
   V11547 = "TXBL Y 3RD XTRA EARNER"
   V11548 = "# EXEMP 3RD XTRA EARNER"
   V11549 = "TAX TABLE 3RD XTRA EARNR"
   V11550 = "SEQ# 4TH OFUM W TXBL Y"
   V11551 = "P PRORAT TXBL Y 4TH OFUM"
   V11552 = "TXBL Y 4TH XTRA EARNER"
   V11553 = "# EXEMP 4TH XTRA EARNER"
   V11554 = "TAX TABLE 4TH XTRA EARNR"
   V11555 = "SEQ# 5TH OFUM W TXBL Y"
   V11556 = "P PRORAT TXBL Y 5TH OFUM"
   V11557 = "TXBL Y 5TH XTRA EARNER"
   V11558 = "# EXEMP 5TH XTRA EARNER"
   V11559 = "TAX TABLE 5TH XTRA EARNR"
   V11560 = "OFUM 84 ANN WRK HRS"
   V11561 = "OFUM 84 TOT ANN TXBL Y"
   V11562 = "ACC OFUM ANN TXBL Y 84"
   V11563 = "OFUM 84 ASSET Y"
   V11564 = "OFUM REC TRANSFER Y?"
   V11565 = "OFUM 84 ADC/AFDC"
   V11566 = "OFUM 84 SSI"
   V11567 = "OFUM 84 OTHER WELFARE"
   V11568 = "OFUM 84 SOC SECURITY"
   V11569 = "OFUM 84 VA PAYMENTS"
   V11570 = "OFUM 84 OTR RETIREMENT"
   V11571 = "OFUM 84 UNEMP COMP"
   V11572 = "OFUM 84 WORKERS COMP"
   V11573 = "OFUM 84 CHILD SUPPORT"
   V11574 = "OFUM 84 HELP FROM RELS"
   V11575 = "OFUM 84 MISC TRANSFERS"
   V11576 = "NOPRO TOT TRANS Y OFUM84"
   V11577 = "PRO TOT TRANS Y OFUM 84"
   V11578 = "ACC OFUM 84 TRANSFERS"
   V11579 = "# OFUM Y RECEIVERS 84"
   V11580 = "# OFUM LABOR Y RECRS 84"
   V11581 = "1968 ID"
   V11582 = "1969 ID"
   V11583 = "1970 ID"
   V11584 = "1971 ID"
   V11585 = "1972 ID"
   V11586 = "1973 ID"
   V11587 = "1974 ID"
   V11588 = "1975 ID"
   V11589 = "1976 ID"
   V11590 = "1977 ID"
   V11591 = "1978 ID"
   V11592 = "1979 ID"
   V11593 = "1980 ID"
   V11594 = "1981 ID"
   V11595 = "1982 ID"
   V11596 = "1983 ID"
   V11597 = "1984 ID"
   V11598 = "INTERVIEWER ID # 1985"
   V11599 = "INTERVIEWER IN #-HEAD"
   V11600 = "DATE OF 1985 IW-HEAD"
   V11601 = "LENGTH OF 1985 IW-HEAD"
   V11602 = "INTERVIEWER IW #-WIFE"
   V11603 = "DATE OF 1985 IW-WIFE"
   V11604 = "LENGTH OF 1985 IW-WIFE"
   V11605 = "# IN FU"
   V11606 = "AGE OF 1985 HEAD"
   V11607 = "SEX OF 1985 HEAD"
   V11608 = "AGE OF 1985 WIFE"
   V11609 = "# CHILDREN IN FU"
   V11610 = "AGE YOUNGEST CHILD"
   V11611 = "# NONFU SHARING HU"
   V11612 = "A3 MARITAL STATUS"
   V11613 = "A4 TYPE DU"
   V11614 = "A5 ACTUAL # ROOMS"
   V11615 = "A6 TYPE FUEL FOR HEAT:1"
   V11616 = "A6 TYPE FUEL FOR HEAT:2"
   V11617 = "A7 RECD GOVT HTG SUBSDY"
   V11618 = "A9 OWN/RENT OR WHAT"
   V11619 = "A11 HAVE MORTGAGE?"
   V11620 = "A15 # PAY ON MORTGAGE?"
   V11621 = "A16 SECOND MORTGAGE?"
   V11622 = "A17 PROP TAX IN MTG PMT?"
   V11623 = "A21 RENTED FURNISHED?"
   V11624 = "A22 PAY HEAT/ELEC/WATER?"
   V11625 = "A24 HEAT IN MTHLY RENT?"
   V11626 = "A25 WHY NOT OWN/RENT"
   V11627 = "A27 PAY HEAT/ELEC/WATER?"
   V11628 = "A29 MOVD SINCE SPG 84?"
   V11629 = "A30 MONTH MOVED"
   V11630 = "A31 WHY MOVED"
   V11631 = "A32 WTR MIGHT MOVE"
   V11632 = "A33 LIKELIHOOD OF MOVING"
   V11633 = "A34 WHY MIGHT MOVE"
   V11634 = "A35 WTR OWN CAR/TRUCK"
   V11635 = "A36 # CARS/TRUCKS OWNED"
   V11636 = "A37 # MI DRIVEN-ALL CARS"
   V11637 = "B1 EMPLMT STATUS-HEAD"
   V11638 = "B2 YEAR RETIRED   (HD-E)"
   V11639 = "B3 WORK FOR MONEY?(HD-E)"
   V11640 = "B4 WORK SELF/OTR? (HD-E)"
   V11641 = "B5 CORP/UNCORP BUS(HD-E)"
   V11642 = "B6 EMPLY OTR PEOPLE(H-E)"
   V11643 = "B7 #OTR PEOPLE EMPLY H-E"
   V11644 = "B8 SUPERVISE OTR  (HD-E)"
   V11645 = "B9 # OTR SUPERVISE(HD-E)"
   V11646 = "B10 SAY IN PAY/PMTN(H-E)"
   V11647 = "B11 BOSS HAVE SUPR(HD-E)"
   V11648 = "B12 WORK FOR GOVT?(HD-E)"
   V11649 = "B13 JOB NOW UNION? (H-E)"
   V11650 = "B14 BELONG UNION? (HD-E)"
   V11651 = "B15-16 MAIN OCC:3DIG H-E"
   V11652 = "B17 MAIN IND:3 DIGT(H-E)"
   V11653 = "B18 SLRY/HRLY/OTR  (H-E)"
   V11654 = "B19 PAY/HR-SALARY (HD-E)"
   V11655 = "B20 WTR SAL PD OT (HD-E)"
   V11656 = "B21 PAY/HR-SLRYOT (HD-E)"
   V11657 = "B22 PAY/HR-HOURLY (HD-E)"
   V11658 = "B23 PAY/HR-HRLY OT (H-E)"
   V11659 = "B24 HOW PAID-OTR  (HD-E)"
   V11660 = "B25 PAY/HR-OTR OT  (H-E)"
   V11661 = "B27 # MI TO WORK  (HD-E)"
   V11662 = "B28 MODE OF TRAVEL (H-E)"
   V11663 = "B29 FORMAL ED REQ?(HD-E)"
   V11664 = "B30 SPEC TRNG REQ?(HD-E)"
   V11665 = "B31 # MOS TO TRAIN(HD-E)"
   V11666 = "B32 GET NEW JOB?  (HD-E)"
   V11667 = "B33 WHAT DO-NEW JOB(H-E)"
   V11668 = "B35 #MO PRESENT EMP(H-E)"
   V11669 = "B36 #MO PRESENT POS(H-E)"
   V11670 = "B36 MO ST PRES POS(HD-E)"
   V11671 = "B36 YR ST PRES POS(HD-E)"
   V11672 = "B37 POS TO BE PERM?(H-E)"
   V11673 = "B38 STARTING WAGE (HD-E)"
   V11674 = "B39 HR/WK WORKED  (HD-E)"
   V11675 = "B40 ONLY JOB OPP? (HD-E)"
   V11676 = "B41 EMP BEFORE NOW?(H-E)"
   V11677 = "B42 WRKG BEFORE NOW? H-E"
   V11678 = "B43 WRKG SAME EMP? (H-E)"
   V11679 = "B44 WHY LFT LAST POS H-E"
   V11680 = "B45 MO LAST POS END(H-E)"
   V11681 = "B45 YR LAST POS END(H-E)"
   V11682 = "B47 WRK GOV-LAST POS?H-E"
   V11683 = "B48 LAST INDUSTRY (HD-E)"
   V11684 = "B49-50 LAST OCC    (H-E)"
   V11685 = "B51 LAST END WAGE  (H-E)"
   V11686 = "B52 LAST END HR/WK (H-E)"
   V11687 = "B53 MO ST LAST JOB(HD-E)"
   V11688 = "B53 YR ST LAST JOB(HD-E)"
   V11689 = "B54 POS TO BE PERM?(H-E)"
   V11690 = "B55 LAST START WAGE(H-E)"
   V11691 = "B56 LAST START HR/WK H-E"
   V11692 = "B-# WRK HIST SUPPS (H-E)"
   V11693 = "B57 WTR OTRS ILL  (HD-E)"
   V11694 = "B58 # WKS OTR ILL (HD-E)"
   V11695 = "B60 WTR SELF ILL  (HD-E)"
   V11696 = "B61 # WKS SELF ILL(HD-E)"
   V11697 = "B63 WTR VACATION  (HD-E)"
   V11698 = "B64 # WK VACATION (HD-E)"
   V11699 = "B66 WTR STRIKE    (HD-E)"
   V11700 = "B67 # WK ON STRIKE (H-E)"
   V11701 = "B69 WTR UNEMPLOYED(HD-E)"
   V11702 = "B70 # WK UNEMPLOYED(H-E)"
   V11703 = "B72 WTR OUT LAB FRC(H-E)"
   V11704 = "B73 #WK OUT LAB FRC(H-E)"
   V11705 = "B75 # WKS WORKED  (HD-E)"
   V11706 = "B76 # HR/WK WORKED (H-E)"
   V11707 = "B77 WTR WORKED OT (HD-E)"
   V11708 = "B79 WTR XTRA JOBS (HD-E)"
   V11709 = "B79-86 # XTRA JOBS (H-E)"
   V11710 = "B80 OCC-XTRA JOB1 (HD-E)"
   V11711 = "B82 PAY/HR XTRA JB1(H-E)"
   V11712 = "B83 # WKS XTRA JOB1(H-E)"
   V11713 = "B85 HR/WK XTRA JOB1(H-E)"
   V11714 = "B80 OCC-XTRA JOB2 (HD-E)"
   V11715 = "B82 AV PY/HR X JB2+(H-E)"
   V11716 = "B83 #WKS XTRA JOB2+(H-E)"
   V11717 = "B85 AV HR/WK X JB2+(H-E)"
   V11718 = "B87 WTR UNEMP 85   (H-E)"
   V11719 = "B88 # WK UNEMP 85  (H-E)"
   V11720 = "B90 OUT LAB FRC 85?(H-E)"
   V11721 = "B91 # WK OUT LF 85 (H-E)"
   V11722 = "B93 # WKS WORKED 85(H-E)"
   V11723 = "B95 #  HR/WK WRKD 85 H-E"
   V11724 = "B96 WTR XTRA JOB 85(H-E)"
   V11725 = "B96 # XTRA JOBS 85 (H-E)"
   V11726 = "B97 OCC-XTRA JOB1 (HD-E)"
   V11727 = "B99 # WKS XTRA JOB1(H-E)"
   V11728 = "B101 HR/WK XTRA JOB(H-E)"
   V11729 = "B97 OCC-XTRA JOB2+(HD-E)"
   V11730 = "B99 #WKS XTRA JOB2+(H-E)"
   V11731 = "B101 AV HR/WK X JB2+ H-E"
   V11732 = "B103 WTR MORE WORK (H-E)"
   V11733 = "B104 PAY/HR MORE WRK H-E"
   V11734 = "B105 COULD WRK LESS(H-E)"
   V11735 = "B106 WANT WRK LESS?(H-E)"
   V11736 = "B107 WANT WRK MORE?(H-E)"
   V11737 = "B108 COULD WRK LESS(H-E)"
   V11738 = "B109 WANT WRK LESS?(H-E)"
   V11739 = "B110 YRS WRKD >18  (H-E)"
   V11740 = "B111 YR WRKD FL TIME H-E"
   V11741 = "B112 P NOT FULL TIME H-E"
   V11742 = "B112 ACC P NO FL TIM H-E"
   V11743 = "C1 WTR LOOK FOR JOB(H-U)"
   V11744 = "C2 # PLACES LOOKED (H-U)"
   V11745 = "C3 OCC-JOB SOUGHT (HD-U)"
   V11746 = "C4 WTR NEED TRAING (H-U)"
   V11747 = "C5 RESERVATION WAGE HD-U"
   V11748 = "C6 #WKS LOOK WORK (HD-U)"
   V11749 = "C7 JOB IN FUTURE?  (H-U)"
   V11750 = "C8 WHEN GET JOB   (HD-U)"
   V11751 = "C9 EVER WORKED?   (HD-U)"
   V11752 = "C10 MO JOB ENDED  (HD-U)"
   V11753 = "C10 YR JOB ENDED  (HD-U)"
   V11754 = "C11 WTR UNEMP 84   (H-U)"
   V11755 = "C12 # WK UNEMP 84  (H-U)"
   V11756 = "C14 WTR UNEMP 85   (H-U)"
   V11757 = "C15 # WK UNEMP 85  (H-U)"
   V11758 = "C17-18 OCC-LAST JOB(H-U)"
   V11759 = "C19 IND-LAST JOB  (HD-U)"
   V11760 = "C20 WRK SELF/OTR? (HD-U)"
   V11761 = "C21 WORK FOR GOVT? (H-U)"
   V11762 = "C23 # MI TO WORK   (H-U)"
   V11763 = "C24 MODE OF TRAVEL (H-U)"
   V11764 = "C25 WHY LAST POS END H-U"
   V11765 = "C26 MO LAST POS END(H-U)"
   V11766 = "C26 YR LAST POS END(H-U)"
   V11767 = "C27 LAST END WAGE (HD-U)"
   V11768 = "C28 HR/WK LAST JOB (H-U)"
   V11769 = "C29 MO ST LAST POS (H-U)"
   V11770 = "C29 YR ST LAST POS (H-U)"
   V11771 = "C30 POS TO BE PERM?(H-U)"
   V11772 = "C31 LAST START WAGE(H-U)"
   V11773 = "C32 LAST START HR/WK H-U"
   V11774 = "C33 EMP BEFORE THEN? H-U"
   V11775 = "C34 WRK BEFORE THEN? H-U"
   V11776 = "C35 WRKG SAME EMP? (H-U)"
   V11777 = "C36 MO PREV POS END(H-U)"
   V11778 = "C36 YR PREV POS END(H-U)"
   V11779 = "C38 WRK GOV-PREV POS?H-U"
   V11780 = "C39 PREV INDUSTRY (HD-U)"
   V11781 = "C40-41 PREV OCC    (H-U)"
   V11782 = "C42 PREV END WAGE (HD-U)"
   V11783 = "C43 PREV END HR/WK(HD-U)"
   V11784 = "C44 MO ST PREV POS(HD-U)"
   V11785 = "C44 YR ST PREV POS(HD-U)"
   V11786 = "C45 POS TO BE PERM?(H-U)"
   V11787 = "C46 PREV START WAGE(H-U)"
   V11788 = "C47 PREV START HR/WK H-U"
   V11789 = "C-# WORK HIST SUPPS(H-U)"
   V11790 = "C48 WTR VACATION  (HD-U)"
   V11791 = "C49 #WKS VACATION (HD-U)"
   V11792 = "C51 WTR OTRS ILL  (HD-U)"
   V11793 = "C52 #WKS OTRS ILL (HD-U)"
   V11794 = "C54 WTR SELF ILL  (HD-U)"
   V11795 = "C55 #WKS SELF ILL (HD-U)"
   V11796 = "C57 WTR ON STRIKE (HD-U)"
   V11797 = "C58 #WKS ON STRIKE (H-U)"
   V11798 = "C60 WTR UNEMPLOYED (H-U)"
   V11799 = "C61 #WK UNEMPLOYED (H-U)"
   V11800 = "C63 WTR OUT LAB FRC(H-U)"
   V11801 = "C64 #WKS OUT LAB FRC H-U"
   V11802 = "C66 # WKS WORKED  (HD-U)"
   V11803 = "C67 HR/WK WORKED  (HD-U)"
   V11804 = "C68 WTR XTRA JOBS (HD-U)"
   V11805 = "C68-75 # XTRA JOBS (H-U)"
   V11806 = "C69 OCC-XTRA JOB1 (HD-U)"
   V11807 = "C71 PAY/HR XTRA JOB1 H-U"
   V11808 = "C72 # WKS EXTRA JOB1 H-U"
   V11809 = "C74 HR/WK XTRA JOB1(H-U)"
   V11810 = "C69 OCC-XTRA JOB2 (HD-U)"
   V11811 = "C71 AV PY/HR X JB2+(H-U)"
   V11812 = "C72 # WK XTRA JOB2+(H-U)"
   V11813 = "C74 AV HR/WK X JB2+(H-U)"
   V11814 = "C76 WTR UNEMP 85   (H-U)"
   V11815 = "C77 # WK UNEMP 85  (H-U)"
   V11816 = "C79 OUT LAB FRC 85?(H-U)"
   V11817 = "C80 # WK OUT LF 85 (H-U)"
   V11818 = "C82 # WKS WORKED 85(H-E)"
   V11819 = "C84 HR/WK WRKD 85  (H-E)"
   V11820 = "C85 WTR XTRA JOB 85(H-U)"
   V11821 = "C85 # XTRA JOBS 85 (H-U)"
   V11822 = "C86-87 OCC-XTRA JOB(H-U)"
   V11823 = "C88 # WKS EXTRA JOB1 H-U"
   V11824 = "C90 HR/WK XTRA JOB1(H-U)"
   V11825 = "C86-87 OCC-XTRA JOB2 H-U"
   V11826 = "C88 # WK XTRA JOB2+(H-U)"
   V11827 = "C90 AV HR/WK X JB2+(H-U)"
   V11828 = "C92 YRS WRKD >18   (H-U)"
   V11829 = "C93 YR WRKD FL TIME(H-U)"
   V11830 = "C94 P NOT FULL TIME(H-U)"
   V11831 = "C94 ACC P NO FL TIME H-U"
   V11832 = "D2 # MARRIAGES-HEAD"
   V11833 = "D3 YEAR 1ST MARRIAGE"
   V11834 = "D5 HOW 1ST MARRIAGE END"
   V11835 = "D6 YEAR 1ST WIDOWED"
   V11836 = "D7 YEAR 1ST DIVORCED"
   V11837 = "D8 YR 1ST SEPARATED"
   V11838 = "D17 YEAR LAST MARRIAGE"
   V11839 = "D20 YEAR LAST WIDOWED"
   V11840 = "D21 YEAR LAST DIVORCED"
   V11841 = "D22 YEAR LAST SEPARATED"
   V11842 = "# CHILD BORN LAST MARR"
   V11843 = "E1 CKPT: SEX OF HEAD"
   V11844 = "E2 # OWN CHILDREN-MALE H"
   V11845 = "E3 CKPT: WIFE IN FU"
   V11846 = "E5 CHILD BY OTR WOMAN?"
   V11847 = "E7 CKPT: WIFE IN FU"
   V11848 = "E9 ALL CHLD BY OTR WOMAN"
   V11849 = "E10 # CHLD BY OTR WOMAN"
   V11850 = "# OWN CHILDREN NOW IN FU"
   V11851 = "# CHILDREN BY WIFE"
   V11852 = "# CHILD BY WF NOW IN FU"
   V11853 = "E36/E38 WANT CHILD?"
   V11854 = "E37/E39 PREG AT RT TIME?"
   V11855 = "MONTH LST/ONLY CHLD BORN"
   V11856 = "YEAR LST/ONLY CHILD BORN"
   V11857 = "E41 WANT PREV CHILD?"
   V11858 = "MONTH PREV CHILD BORN"
   V11859 = "YEAR PREV CHILD BORN"
   V11860 = "E42 WANT 1ST CHILD?"
   V11861 = "E43 PREG AT RIGHT TIME?"
   V11862 = "MONTH FIRST CHILD BORN"
   V11863 = "YEAR FIRST CHILD BORN"
   V11864 = "E44 CKPT: WIFE <45 IN FU"
   V11865 = "E45 WIFE PREGNANT NOW?"
   V11866 = "E46 WANT MORE CHILDREN?"
   V11867 = "E47 # CHILDREN WANTED"
   V11868 = "E48 WANT MORE CHILDREN?"
   V11869 = "E49 # CHILDREN WANTED"
   V11870 = "E50 WTR FERTILITY PROB"
   V11871 = "E51 YR PROBLEMS BEGAN"
   V11872 = "E52 CKPT: WIFE <45 IN FU"
   V11873 = "E53 WIFE PREGNANT NOW?"
   V11874 = "E54 WANT MORE CHILDREN?"
   V11875 = "E55 # CHILDREN WANTED"
   V11876 = "E56 WTR WANT CHILDREN"
   V11877 = "E57 # CHILDREN WANTED"
   V11878 = "E58 WTR FERTILITY PROB"
   V11879 = "E59 YR PROBLEMS BEGAN"
   V11880 = "E60 WTR ADOPTED CHILDREN"
   V11881 = "E61 # ADOPTED CHILDREN"
   V11882 = "# ADOPTED CHLD NOW IN FU"
   V11883 = "E86 WTR RAISED CHILDREN"
   V11884 = "E87 # CHILDREN RAISED"
   V11885 = "# RAISED CHLD NOW IN FU"
   V11886 = "F2 WHETHER HEAD FARMER"
   V11887 = "F3 TOTAL FARM RECEIPTS"
   V11888 = "F6 WHETHER BUSINESS"
   V11889 = "F7 TYP BUS HAVE INT IN"
   V11890 = "F8 WHO IN FAM OWNED BUS"
   V11891 = "F9 R PUT TIME IN BUS 84?"
   V11892 = "F10 CORP/UNINCORP BUS"
   V11893 = "F99 WTR LUMP SUM PAYMNTS"
   V11894 = "F100 LUMP SUM PAYMNTS"
   V11895 = "F101 WTR ITEM 84 TAX DED"
   V11896 = "F102 WTR HELP SUPPORT OT"
   V11897 = "F103 # OTRS SUPPORTED"
   V11898 = "F104 WHO SUPPORTED #1"
   V11899 = "F104 WHO SUPPORTED #2"
   V11900 = "F104 WHO SUPPORTED #3"
   V11901 = "F106 PAY CHILD SUPP 84"
   V11902 = "F108 PAY ALIMONY 84"
   V11903 = "F111 WTR DEPENDENT OTRS"
   V11904 = "F112 # OTR DEPENDENTS"
   V11905 = "F113 WTR DEPENDENT OTR"
   V11906 = "G1 CKPT: WTR NEW HEAD"
   V11907 = "G2 STATE FA GREW UP-HD"
   V11908 = "G2 CNTY FA GREW UP-HD"
   V11909 = "G3 STATE MO GREW UP-HD"
   V11910 = "G3 CNTY MO GREW UP-HD"
   V11911 = "G4 OCCUPATION OF FA-HD"
   V11912 = "G5 FIRST OCCUPATION-HD"
   V11913 = "G6 # DIFF JOBS OR?-HD"
   V11914 = "G7 GREW UP FARM OR-HD"
   V11915 = "G8-9 STATE GREW UP-HD"
   V11916 = "G8-9 CNTY GREW UP-HD"
   V11917 = "G8-10 #REGIONS LIVED-HD"
   V11918 = "G8-10 #STATES LIVED-HD"
   V11919 = "G11 EVER MOVE FOR JOB?HD"
   V11920 = "G12 NOT MOVED FOR JOB?HD"
   V11921 = "G13 PARENTS POOR OR?-HD"
   V11922 = "G14-15 EDUC OF FATHER-H"
   V11923 = "G16-17 EDUC OF MOTHER-H"
   V11924 = "G18 WTR BROTHERS-HEAD"
   V11925 = "G19 # BROTHERS-HEAD"
   V11926 = "G20 ONLY BRO STILL ALIVE"
   V11927 = "G21 ONLY BRO OLDR THAN H"
   V11928 = "G22 # BRO STILL ALIVE"
   V11929 = "G23 ANY BRO OLDR THAN H"
   V11930 = "G24 WTR SISTERS-HEAD"
   V11931 = "G25 # SISTERS-HEAD"
   V11932 = "G26 ONLY SIS STILL ALIVE"
   V11933 = "G27 ONLY SIS OLDR THAN H"
   V11934 = "G28 # SIS STILL ALIVE"
   V11935 = "G29 ANY SIS OLDR THAN H"
   V11936 = "G30 LIVE W BOTH PARENTS"
   V11937 = "G31 SPANISH DESCENT-HEAD"
   V11938 = "G32 RACE OF HEAD (1 MEN)"
   V11939 = "G32 RACE OF HEAD (2 MEN)"
   V11940 = "G33 WTR IN MILIT SERV"
   V11941 = "G34 MO BEGAN MILIT SERV"
   V11942 = "G34 YR BEGAN MILIT SERV"
   V11943 = "G35 MO ENDED MILIT SERV"
   V11944 = "G35 YR ENDED MILIT SERV"
   V11945 = "G36 WTR GRADUATED HS"
   V11946 = "G37 MO GRADUATED HS"
   V11947 = "G37 YR GRADUATED HS"
   V11948 = "G38 GRADE LEVEL IF GED"
   V11949 = "G39 MO LAST IN SCH-GED"
   V11950 = "G39 YR LAST IN SCH-GED"
   V11951 = "G40 MO RECEIVED GED"
   V11952 = "G40 YR RECEIVED GED"
   V11953 = "G41 GRADE OF SCH FINISH"
   V11954 = "G42 MO LAST IN SCH-NONGR"
   V11955 = "G42 YR LAST IN SCH-NONGR"
   V11956 = "G43 WTR ATTEND COLLEGE"
   V11957 = "G44 MO LAST ATTEND COLL"
   V11958 = "G44 YR LAST ATTEND COLL"
   V11959 = "G45 HIGHEST YR COLL COMP"
   V11960 = "G46 WTR RECD COLL DEGREE"
   V11961 = "G47 HIGHEST COLL DEG REC"
   V11962 = "G50 MO RECD COLL DEG"
   V11963 = "G50 YR RECD COLL DEG"
   V11964 = "G51 WTR REC OTR DEG/CERT"
   V11965 = "G51 # OTR DEG/CERT REC"
   V11966 = "G52A TYPE OTR DEG/CERT 1"
   V11967 = "G53A FIELD OF DEG/CERT 1"
   V11968 = "G54A INST/ORG DEG/CERT 1"
   V11969 = "G55A MO REC DEG/CERT 1"
   V11970 = "G55A YR REC DEG/CERT 1"
   V11971 = "G52B TYPE OTR DEG/CERT 2"
   V11972 = "G53B FIELD OF DEG/CERT 2"
   V11973 = "G54B INST/ORG DEG/CERT 2"
   V11974 = "G55B MO REC DEG/CERT 2"
   V11975 = "G55B YR REC DEG/CERT 2"
   V11976 = "G52C TYPE OTR DEG/CERT 3"
   V11977 = "G53C FIELD OF DEG/CERT 3"
   V11978 = "G54C INST/ORG DEG/CERT 3"
   V11979 = "G55C MO REC DEG/CERT 3"
   V11980 = "G55C YR REC DEG/CERT 3"
   V11981 = "G57-58 RELIGIOUS PREF"
   V11982 = "H1 HOUSEWORK HOURS-HEAD"
   V11983 = "H2 CKPT:# IN FU"
   V11984 = "H3 OTRS HELP W HSWRK?"
   V11985 = "H23 CKPT: CHILDCARE"
   V11986 = "H24 CHILDCARE ARRANG 1"
   V11987 = "H24 CHILDCARE ARRANG 2"
   V11988 = "H24 CHILDCARE ARRANG 3"
   V11989 = "H25 CHILDCARE IN HOME"
   V11990 = "H26 COST CHILD CARE 84"
   V11991 = "H27 HEALTH NOW-HEAD"
   V11992 = "H28 HLTH 85 VS 83-HEAD"
   V11993 = "H29 WTR PHYS/NERV PROB-H"
   V11994 = "H30 HOW MUCH LIMIT-HD"
   V11995 = "H31 WTR HEAD IN HOSPITAL"
   V11996 = "H32 # NIGHTS IN HOSP-H"
   V11997 = "H33 WTR MEDICARE/AID"
   V11998 = "H34 TYPE PROGRAM"
   V11999 = "J1A CKPT:WIFE IN FU-WIFE"
   V12000 = "J1F EMPLMT STATUS-WIFE"
   V12001 = "J2 YEAR RETIRED   (WF-E)"
   V12002 = "J3 WORK FOR MONEY?(WF-E)"
   V12003 = "J4 WORK SELF/OTR? (WF-E)"
   V12004 = "J5 CORP/UNCORP BUS(WF-E)"
   V12005 = "J6 EMPLY OTR PEOPLE(W-E)"
   V12006 = "J7 #OTH PEOPLE EMPLY W-E"
   V12007 = "J8 SUPERVISE OTR  (WF-E)"
   V12008 = "J9 # OTR SUPERVISE(WF-E)"
   V12009 = "J10 SAY IN PAY/PMTH(W-E)"
   V12010 = "J11 BOSS HAVE SUPR(WF-E)"
   V12011 = "J12 WORK FOR GOVT?(WF-E)"
   V12012 = "J13 JOB NOW UNION? (W-E)"
   V12013 = "J14 BELONG UNION? (WF-E)"
   V12014 = "J15-16 MAIN OCC:3DIG W-E"
   V12015 = "J17 MAIN IND:3 DIGT(W-E)"
   V12016 = "J18 SLRY/HRLY/OTR  (W-E)"
   V12017 = "J19 PAY/HR-SALARY (WF-E)"
   V12018 = "J20 WTR SAL PD OT (WF-E)"
   V12019 = "J21 PAY/HR-SLRYOT (WF-E)"
   V12020 = "J22 PAY/HR-HOURLY (WF-E)"
   V12021 = "J23 PAY/HR-HRLY OT (W-E)"
   V12022 = "J24 HOW PAID-OTR  (WF-E)"
   V12023 = "J25 PAY/HR-OTR OT  (W-E)"
   V12024 = "J27 # MI TO WORK  (WF-E)"
   V12025 = "J28 MODE OF TRAVEL (W-E)"
   V12026 = "J29 FORMAL ED REQ?(WF-E)"
   V12027 = "J30 SPEC TRNG REQ?(WF-E)"
   V12028 = "J31 # MOS TO TRAIN(WF-E)"
   V12029 = "J32 GET NEW JOB?  (WF-E)"
   V12030 = "J33 WHAT DO-NEW JOB(W-E)"
   V12031 = "J35 #MO PRESENT EMP(W-E)"
   V12032 = "J36 #MO PRESENT POS(W-E)"
   V12033 = "J36 MO ST PRES POS(WF-E)"
   V12034 = "J36 YR ST PRES POS(WF-E)"
   V12035 = "J37 POS TO BE PERM?(W-E)"
   V12036 = "J38 STARTING WAGE (WF-E)"
   V12037 = "J39 HR/WK WORKED  (WF-E)"
   V12038 = "J40 ONLY JOB OPP? (WF-E)"
   V12039 = "J41 EMP BEFORE NOW?(W-E)"
   V12040 = "J42 WRKG BEFORE NOW? W-E"
   V12041 = "J43 WRKG SAME EMP? (W-E)"
   V12042 = "J44 WHY LFT LAST POS W-E"
   V12043 = "J45 MO LAST POS END(W-E)"
   V12044 = "J45 YR LAST POS END(W-E)"
   V12045 = "J47 WRK GOV-LAST POS W-E"
   V12046 = "J48 LAST INDUSTRY (WF-E)"
   V12047 = "J49-50 LAST OCC    (W-E)"
   V12048 = "J51 LAST END WAGE (WF-E)"
   V12049 = "J52 LAST END HR/WK (W-E)"
   V12050 = "J53 MO ST LAST JOB(WF-E)"
   V12051 = "J53 YR ST LAST JOB(WF-E)"
   V12052 = "J54 POS TO BE PERM?(W-E)"
   V12053 = "J55 LAST START WAGE(W-E)"
   V12054 = "J56 LAST START HR/WK W-E"
   V12055 = "J-# WRK HIST SUPPS (W-E)"
   V12056 = "J57 WTR OTRS ILL  (WF-E)"
   V12057 = "J58 # WKS OTR ILL (WF-E)"
   V12058 = "J60 WTR SELF ILL  (WF-E)"
   V12059 = "J61 # WKS SELF ILL(WF-E)"
   V12060 = "J63 WTR VACATION  (WF-E)"
   V12061 = "J64 # WK VACATION (WF-E)"
   V12062 = "J66 WTR STRIKE    (WF-E)"
   V12063 = "J67 # WK ON STRIKE (W-E)"
   V12064 = "J69 WTR UNEMPLOYED(WF-E)"
   V12065 = "J70 # WK UNEMPLYED(WF-E)"
   V12066 = "J72 WTR OUT LAB FRC(W-E)"
   V12067 = "J73 #WK OUT LAB FRC(W-E)"
   V12068 = "J75 # WKS WORKED  (WF-E)"
   V12069 = "J76 # HR/WK WRKD  (WF-E)"
   V12070 = "J77 WTR WORKED OT (WF-E)"
   V12071 = "J79 WTR XTRA JOBS (WF-E)"
   V12072 = "J79-86 # XTRA JOBS (W-E)"
   V12073 = "J80 OCC-XTRA JOB1 (WF-E)"
   V12074 = "J82 PAY/HR XTRA JB1(W-E)"
   V12075 = "J83 # WKS XTRA JOB1(W-E)"
   V12076 = "J85 HR/WK XTRA JOB1(W-E)"
   V12077 = "J80 OCC-XTRA JOB2 (WF-E)"
   V12078 = "J82 AV PY/HR X JB2+(W-E)"
   V12079 = "J83 #WKS XTRA JOB2+(W-E)"
   V12080 = "J85 AV HR/WK X JB2+(W-E)"
   V12081 = "J87 WTR UNEMP 85   (W-E)"
   V12082 = "J88 # WK UNEMPLOYED(W-E)"
   V12083 = "J90 OUT LAB FRC 85?(W-E)"
   V12084 = "J91 # WK OUT LF 85 (W-E)"
   V12085 = "J93 # WK WORKED 85 (W-E)"
   V12086 = "J95 # HR/WK WRKD 85(W-E)"
   V12087 = "J96 WTR XTRA JOB 85(W-E)"
   V12088 = "J96 # XTRA JOBS 85 (W-E)"
   V12089 = "J97 OCC-XTRA JOB1 (WF-E)"
   V12090 = "J99 # WKS XTRA JOB1(W-E)"
   V12091 = "J101 HR/WK XTRA JOB(W-E)"
   V12092 = "J97 OCC-XTRA JOB2+(WF-E)"
   V12093 = "J99 #WKS XTR JOB2+ (W-E)"
   V12094 = "J101 AV HR/WK X JB2+ W-E"
   V12095 = "J103 WTR MORE WORK (W-E)"
   V12096 = "J104 PAY/HR MOR WRK(W-E)"
   V12097 = "J105 COULD WRK LESS(W-E)"
   V12098 = "J106 WANT WRK LESS?(W-E)"
   V12099 = "J107 WANT WRK MORE?(W-E)"
   V12100 = "J108 COULD WRK LESS(W-E)"
   V12101 = "J109 WANT WRK LESS?(W-E)"
   V12102 = "J110 YRS WRKD >18  (W-E)"
   V12103 = "J111 YR WRKD FL TIME W-E"
   V12104 = "J112 P NOT FULL TIME W-E"
   V12105 = "J112 ACC P NO FL TIM W-E"
   V12106 = "K1 WTR LOOK FOR JOB(W-U)"
   V12107 = "K2 # PLACES LOOKED (W-U)"
   V12108 = "K3 OCC-JOB SOUGHT (WF-U)"
   V12109 = "K4 WTR NEED TRAING (W-U)"
   V12110 = "K5 RESERVATION WAGE(W-U)"
   V12111 = "K6 # WKS LOOK WORK (W-U)"
   V12112 = "K7 JOB IN FUTURE?  (W-U)"
   V12113 = "K8 WHEN GET JOB   (WF-U)"
   V12114 = "K9 EVER WORKED?   (WF-U)"
   V12115 = "K10 MO JOB ENDED  (WF-U)"
   V12116 = "K10 YR JOB ENDED  (WF-U)"
   V12117 = "K11 WTR UNEMP 84   (W-U)"
   V12118 = "K12 # WK UNEMP 84  (W-U)"
   V12119 = "K14 WTR UNEMP 85   (W-U)"
   V12120 = "K15 # WK UNEMP 85  (W-U)"
   V12121 = "K17-18 OCC-LAST JOB(W-U)"
   V12122 = "K19 IND-LAST JOB  (WF-U)"
   V12123 = "K20 WORK SELF/OTR?(WF-U)"
   V12124 = "K21 WORK FOR GOVT? (W-U)"
   V12125 = "K23 # MI TO WORK   (W-U)"
   V12126 = "K24 MODE OF TRAVEL (W-U)"
   V12127 = "K25 WHY LAST POS END W-U"
   V12128 = "K26 MO LAST POS END(W-U)"
   V12129 = "K26 YR LAST POS END(W-U)"
   V12130 = "K27 LAST END WAGE (WF-U)"
   V12131 = "K28 HR/WK LAST JOB (W-U)"
   V12132 = "K29 MO ST LAST POS (W-U)"
   V12133 = "K29 YR ST LAST POS (W-U)"
   V12134 = "K30 POS TO BE PERM?(W-U)"
   V12135 = "K31 LAST START WAGE(W-U)"
   V12136 = "K32 LAST START HR/WK W-U"
   V12137 = "K33 EMP BEFORE THEN? W-U"
   V12138 = "K34 WRK BEFORE THEN? W-U"
   V12139 = "K35 WRKG SAME EMP? (W-U)"
   V12140 = "K36 MO PREV POS END(W-U)"
   V12141 = "K36 YR PREV POS END(W-U)"
   V12142 = "K38 WRK GOV-PREV POS?W-U"
   V12143 = "K39 PREV INDUSTRY (WF-U)"
   V12144 = "K40-41 PREV OCC    (W-U)"
   V12145 = "K42 PREV END WAGE (WF-U)"
   V12146 = "K43 PREV END HR/WK (W-U)"
   V12147 = "K44 MO ST PREV POS(WF-U)"
   V12148 = "K44 YR ST PREV POS(WF-U)"
   V12149 = "K45 POS TO BE PERM?(W-U)"
   V12150 = "K46 PREV START WAGE(W-U)"
   V12151 = "K47 PREV START HR/WK W-U"
   V12152 = "K-# WORK HIST SUPPS(W-U)"
   V12153 = "K48 WTR VACATION  (WF-U)"
   V12154 = "K49 #WKS VACATION (WF-U)"
   V12155 = "K51 WTR OTRS ILL  (WF-U)"
   V12156 = "K52 #WKS OTRS ILL (WF-U)"
   V12157 = "K54 WTR SELF ILL  (WF-U)"
   V12158 = "K55 #WKS SELF ILL (WF-U)"
   V12159 = "K57 WTR ON STRIKE (WF-U)"
   V12160 = "K58 #WKS ON STRIKE (W-U)"
   V12161 = "K60 WTR UNEMPLOYED(WF-U)"
   V12162 = "K61 #WKS UNEMPLYD (WF-U)"
   V12163 = "K63 WTR OUT LAB FRC(W-U)"
   V12164 = "K64 #WKS OUT LAB FRC W-U"
   V12165 = "K66 #WKS WORKED   (WF-U)"
   V12166 = "K67 HR/WK WORKED  (WF-U)"
   V12167 = "K68 WTR XTRA JOBS (WF-U)"
   V12168 = "K68-75 # XTRA JOBS (W-U)"
   V12169 = "K69 OCC-XTRA JOB1 (WF-U)"
   V12170 = "K71 PAY/HR XTRA JOB(W-U)"
   V12171 = "K72 # WKS XTRA JOB1(W-U)"
   V12172 = "K74 HR/WK XTRA JOB1(W-U)"
   V12173 = "K69 OCC-XTRA JOB2 (WF-U)"
   V12174 = "K71 AV PY/HR X JB2+(W-U)"
   V12175 = "K72 # WK XTRA JOB2+(W-U)"
   V12176 = "K74 AV HR/WK X JB2+(W-U)"
   V12177 = "K76 WTR UNEMP 85   (W-U)"
   V12178 = "K77 # WK UNEMP 85  (W-U)"
   V12179 = "K79 WTR OUT LF 85? (W-U)"
   V12180 = "K80 # WK OUT LF 85 (W-U)"
   V12181 = "K82 # WKS WORKED 85(W-U)"
   V12182 = "K84 HR/WK WORKED 85(W-U)"
   V12183 = "K85 WTR XTRA JOB 85(W-U)"
   V12184 = "K85 # XTRA JOBS 85 (W-U)"
   V12185 = "K86-87 OCC-XTRA JOB1 W-U"
   V12186 = "K88 # WKS XTRA JOB1(W-U)"
   V12187 = "K90 HR/WK XTRA JOB1(W-U)"
   V12188 = "K86-87 OCC-XTRA JOB2 W-U"
   V12189 = "K88 # WK XTRA JOB2+(W-U)"
   V12190 = "K90 AV HR/WK X JB2+(W-U)"
   V12191 = "K92 YRS WKD >18    (W-U)"
   V12192 = "K93 #YRS WKD FL TIME W-U"
   V12193 = "K94 P NOT FULL TIME(W-U)"
   V12194 = "K94 ACC P NO FL TIME W-U"
   V12195 = "L1A WIFE OR FRIEND IN FU"
   V12196 = "L1B MAR STAT OF FRIEND"
   V12197 = "L2 # MARRIAGES-WIFE"
   V12198 = "L3 YEAR 1ST MARRIAGE"
   V12199 = "L5 HOW 1ST MARRIAGE END"
   V12200 = "L6 YEAR 1ST WIDOWED"
   V12201 = "L7 YEAR 1ST DIVORCED"
   V12202 = "L8 YR 1ST SEPARATED"
   V12203 = "L17 YEAR LAST MARRIAGE"
   V12204 = "L20 YEAR LAST WIDOWED"
   V12205 = "L21 YEAR LAST DIVORCED"
   V12206 = "L22 YEAR LAST SEPARATED"
   V12207 = "# CHILD BORN LAST MARR"
   V12208 = "M1 # OWN CHILDREN-FEMALE"
   V12209 = "# OWN CHILDREN NOW IN FU"
   V12210 = "M4 CKPT: WIFE IN FU"
   V12211 = "M5 CHILD BY OTR MAN?"
   V12212 = "M8 CKPT: WIFE IN FU"
   V12213 = "M9 ANY CHILD BY OTR MAN"
   V12214 = "# CHILDREN BY OTR MAN"
   V12215 = "# CHLD BY OTR NOW IN FU"
   V12216 = "# CHILDREN BORN 79-85"
   V12217 = "# PREG PRENATAL DR VISIT"
   V12218 = "# PREG PAID BY PVT INS"
   V12219 = "# PREG PAID BY MEDICAID"
   V12220 = "# PREG WIC PROGRAM"
   V12221 = "# PREG REC FOOD STAMPS"
   V12222 = "# PREG OTR GOV FREE FOOD"
   V12223 = "# PREG REC ADC/AFDC"
   V12224 = "# PREG OTR PUB ASSIST"
   V12225 = "M64/M66 WANT CHILD?"
   V12226 = "M65/M67 PREG AT RT TIME?"
   V12227 = "MONTH LST/ONLY CHLD BORN"
   V12228 = "YEAR LST/ONLY CHILD BORN"
   V12229 = "SAME HDS LST/ONLY CHILD"
   V12230 = "M69 WANT PREV CHILD?"
   V12231 = "MONTH PREV CHILD BORN"
   V12232 = "YEAR PREV CHILD BORN"
   V12233 = "SAME AS HDS PREV CHILD"
   V12234 = "M70 WANT 1ST CHILD?"
   V12235 = "M71 PREG AT RIGHT TIME?"
   V12236 = "MONTH FIRST CHILD BORN"
   V12237 = "YEAR FIRST CHILD BORN"
   V12238 = "SAME AS HDS FIRST CHILD"
   V12239 = "M72 CKPT: FEM HD/WF <45"
   V12240 = "M73 FEM HD/WF PREG NOW?"
   V12241 = "M74 WANT MORE CHILDREN?"
   V12242 = "M75 # CHILDREN WANTED"
   V12243 = "M76 WANT MORE CHILDREN?"
   V12244 = "M77 # CHILDREN WANTED"
   V12245 = "M78 WTR FERTILITY PROB"
   V12246 = "M79 YR PROBLEMS BEGAN"
   V12247 = "M80 CKPT: FEM HD/WF <45"
   V12248 = "M81 FEM HD/WF PREG NOW?"
   V12249 = "M82 WANT MORE CHILDREN?"
   V12250 = "M83 # CHILDREN WANTED"
   V12251 = "M84 WTR WANT CHILDREN"
   V12252 = "M85 # CHILDREN WANTED"
   V12253 = "M86 WTR FERTILITY PROB"
   V12254 = "M87 YR PROBLEMS BEGAN"
   V12255 = "M88 WTR ADOPTED CHILDREN"
   V12256 = "M89 # ADOPTED CHILDREN"
   V12257 = "# ADOPTED CHLD NOW IN FU"
   V12258 = "M114 WTR RAISED CHILDREN"
   V12259 = "M115 # OTR CHILDRN RAISE"
   V12260 = "# RAISED CHLD NOW IN FU"
   V12261 = "N1 CKPT: WTR WIFE"
   V12262 = "N2 STATE FA GREW UP-WF"
   V12263 = "N2 CNTY FA GREW UP-WF"
   V12264 = "N3 STATE MO GREW UP-WF"
   V12265 = "N3 CNTY MO GREW UP-WF"
   V12266 = "N4 OCCUPATION OF FA-WF"
   V12267 = "N5 FIRST OCCUPATION-WF"
   V12268 = "N6 # DIFF JOBS OR?-WF"
   V12269 = "N7 GREW UP FARM OR-WF"
   V12270 = "N8-9 STATE GREW UP-WF"
   V12271 = "N8-9 CNTY GREW UP-WF"
   V12272 = "N8-10 #REGIONS LIVED-WF"
   V12273 = "N8-10 #STATES LIVED-WF"
   V12274 = "N11 EVER MOVE FOR JOB?WF"
   V12275 = "N12 NOT MOVED FOR JOB?WF"
   V12276 = "N13 PARENTS POOR OR?-WF"
   V12277 = "N14-15 EDUC OF FATHER-WF"
   V12278 = "N16-17 EDUC OF MOTHER-WF"
   V12279 = "N18 WTR BROTHERS-WIFE"
   V12280 = "N19 # BROTHERS-WIFE"
   V12281 = "N20 ONLY BRO STILL ALIVE"
   V12282 = "N21 ONLY BRO OLDR THAN W"
   V12283 = "N22 # BRO STILL ALIVE"
   V12284 = "N23 ANY BRO OLDR THAN WF"
   V12285 = "N24 WTR SISTERS-WIFE"
   V12286 = "N25 # SISTERS-WIFE"
   V12287 = "N26 ONLY SIS STILL ALIVE"
   V12288 = "N27 ONLY SIS OLDR THAN W"
   V12289 = "N28 # SIS STILL ALIVE"
   V12290 = "N29 ANY SIS OLDR THAN WF"
   V12291 = "N30 LIVE W BOTH PARENTS"
   V12292 = "N31 SPANISH DESCENT-WIFE"
   V12293 = "N32 RACE OF WIFE (1 MEN)"
   V12294 = "N32 RACE OF WIFE (2 MEN)"
   V12295 = "N33 WTR IN MILIT SERV"
   V12296 = "N34 MO BEGAN MILIT SERV"
   V12297 = "N34 YR BEGAN MILIT SERV"
   V12298 = "N35 MO ENDED MILIT SERV"
   V12299 = "N35 YR ENDED MILIT SERV"
   V12300 = "N36 WTR GRADUATED HS"
   V12301 = "N37 MO GRADUATED HS"
   V12302 = "N37 YR GRADUATED HS"
   V12303 = "N38 GRADE LEVEL IF GED"
   V12304 = "N39 MO LAST IN SCH-GED"
   V12305 = "N39 YR LAST IN SCH-GED"
   V12306 = "N40 MO RECEIVED GED"
   V12307 = "N40 YR RECEIVED GED"
   V12308 = "N41 GRADE OF SCH FINISH"
   V12309 = "N42 MO LAST IN SCH-NONGR"
   V12310 = "N42 YR LAST IN SCH-NONGR"
   V12311 = "N43 WTR ATTEND COLLEGE"
   V12312 = "N44 MO LAST ATTEND COLL"
   V12313 = "N44 YR LAST ATTEND COLL"
   V12314 = "N45 HIGHEST YR COLL COMP"
   V12315 = "N46 WTR REC COLL DEGREE"
   V12316 = "N47 HIGHEST COLL DEG REC"
   V12317 = "N50 MO RECD COLL DEG"
   V12318 = "N50 YR RECD COLL DEG"
   V12319 = "N51 WTR REC OTR DEG/CERT"
   V12320 = "N51 # OTR DEG/CERT REC"
   V12321 = "N52A TYPE OTR DEG/CERT 1"
   V12322 = "N53A FIELD OF DEG/CERT 1"
   V12323 = "N54A INST/ORG DEG/CERT 1"
   V12324 = "N55A MO REC DEG/CERT 1"
   V12325 = "N55A YR REC DEG/CERT 1"
   V12326 = "N52B TYPE OTR DEG/CERT 2"
   V12327 = "N53B FIELD OF DEG/CERT 2"
   V12328 = "N54B INST/ORG DEG/CERT 2"
   V12329 = "N55B MO REC DEG/CERT 2"
   V12330 = "N55B YR REC DEG/CERT 2"
   V12331 = "N52C TYPE OTR DEG/CERT 3"
   V12332 = "N53C FIELD OF DEG/CERT 3"
   V12333 = "N54C INST/ORG DEG/CERT 3"
   V12334 = "N55C MO REC DEG/CERT 3"
   V12335 = "N55C YR REC DEG/CERT 3"
   V12336 = "N57-58 RELIGIOUS PREF"
   V12337 = "P1 HOUSEWORK HOURS-WIFE"
   V12338 = "P2 CKPT: CHILD CARE"
   V12339 = "P3 CHILDCARE ARRANG 1"
   V12340 = "P3 CHILDCARE ARRANG 2"
   V12341 = "P3 CHILDCARE ARRANG 3"
   V12342 = "P4 CHILDCARE IN HOME?"
   V12343 = "P5 COST CHILDCARE 84"
   V12344 = "P6 HEALTH NOW-WIFE"
   V12345 = "P7 HLTH 85 VS 83-WF"
   V12346 = "P8 WTR PHYS/NERV PROB-WF"
   V12347 = "P9 HOW MUCH LIMIT-WF"
   V12348 = "P10 WTR WIFE IN HOSPITAL"
   V12349 = "P11 # NIGHTS IN HOSP-WF"
   V12350 = "Q1 CKPT:OFUM 12-44 IN FU"
   V12351 = "Q2 OFUM <45 W/ CHILDREN?"
   V12352 = "Q4 OFUM <45 EVER MARRIED"
   V12353 = "Q6 #<45 MARR OR W/CHLDRN"
   V12354 = "TN1 WHO RESPONDENT-HEAD"
   V12355 = "TN2 WHO RESPONDENT-WIFE"
   V12356 = "TN3 # OF INTERVWR CALLS"
   V12357 = "# OF INDIVIDUAL RECORDS"
   V12358 = "H+W 1984 FED TAXES"
   V12359 = "H+W 84 MARGINAL TAX RATE"
   V12360 = "1ST XTRA ERNER 84 TAXES"
   V12361 = "MARG TAX RATE ERNR ONE"
   V12362 = "2ND XTRA ERNER 84 TAXES"
   V12363 = "MARG TAX RATE ERNR TWO"
   V12364 = "3RD XTRA ERNER 84 TAXES"
   V12365 = "MARG TAX RATE ERNR THREE"
   V12366 = "4TH XTRA ERNER 84 TAXES"
   V12367 = "MARG TAX RATE ERNR FOUR"
   V12368 = "5TH XTRA ERNER 84 TAXES"
   V12369 = "MARG TAX RATE ERNR FIVE"
   V12370 = "TOT TAXES ALL XTRA ERNR"
   V12371 = "TOT FAM MONEY Y 84"
   V12372 = "TOTAL HEAD LABOR Y 84"
   V12373 = "WEEKLY FOOD NEEDS-1985"
   V12374 = "ANNUAL NEEDS STD-1984"
   V12375 = "1984 TOT FAM Y/NEEDS"
   V12376 = "ANNUAL FOOD STD"
   V12377 = "HEAD 84 AVG HRLY EARNING"
   V12378 = "WIFE 84 AVG HRLY EARNING"
   V12379 = "REGION OF 1985 INTERVIEW"
   V12380 = "STATE CODE (FIPS)"
   V12381 = "COUNTY CODE (FIPS)"
   V12382 = "RURAL-URBAN CODE (BEALE)"
   V12383 = "REGION 85 HD GREW UP"
   V12384 = "REGION 85 HD FA GREW UP"
   V12385 = "REGION 85 HD MO GREW UP"
   V12386 = "HEAD GEOGRAPHIC MOBILITY"
   V12387 = "REGION 85 WF GREW UP"
   V12388 = "REGION 85 WF FA GREW UP"
   V12389 = "REGION 85 WF MO GREW UP"
   V12390 = "WIFE GEOGRAPHIC MOBILITY"
   V12391 = "ACC 84 Y COMPONENTS"
   V12392 = "# MINOR ASSGMTS IN 85"
   V12393 = "# MAJOR ASSGMTS IN 85"
   V12394 = "HU VALUE/ROOM - 1985"
   V12395 = "ACTUL MINUS REQ ROOMS 85"
   V12396 = "PERSON/ROOM IN 1985"
   V12397 = "# 18 OR OLDER IN 85"
   V12398 = "BKT AGE HEAD 1985"
   V12399 = "BKT AGE WIFE 1985"
   V12400 = "EDUCATION 1985 HEAD"
   V12401 = "EDUCATION 1985 WIFE"
   V12402 = "DECILE: 84 TOT FAM Y"
   V12403 = "DECILE: 84 Y/NEEDS"
   V12404 = "# CHILDREN AGE 1-2"
   V12405 = "# CHILDREN AGE 3-5"
   V12406 = "# CHILDREN AGE 6-13"
   V12407 = "# FEM CHILDREN AGE 14-17"
   V12408 = "# MALE CHILDREN 14-17"
   V12409 = "# FEM CHILDREN 18-20"
   V12410 = "# MALE CHILDREN 18-20"
   V12411 = "# FEM CHILDREN 21-29"
   V12412 = "# MALE CHILDREN 21-29"
   V12413 = "# INDS IN ARMED FORCES"
   V12414 = "# INDS INCARCERATED"
   V12415 = "# INDS IN HLTH CARE FAC"
   V12416 = "# INDS IN EDUCATNL FACIL"
   V12417 = "SPLIT SAMPLE FILTER"
   V12418 = "BRR STRATUM"
   V12419 = "BRR SECU"
   V12420 = "PSALMS STRATUM"
   V12421 = "PSALMS SECU"
   V12422 = "UNSKL M CNTY LABOR SUPPL"
   V12423 = "TYPICAL UNSKL WAGE RATE"
   V12424 = "1985 CNTY UNEMP RATE"
   V12425 = "18YR FAM COMP CHANGE"
   V12426 = "MARITAL STATUS 1985"
   V12427 = "84-85 CNG MARITAL STATUS"
   V12428 = "COUPLE STATUS OF HEAD"
   V12429 = "YR NEW HEAD IN FU"
   V12430 = "YR NEW WIFE IN FU"
   V12431 = "HD-SPOUSE SAMPLE STATUS"
   V12432 = "# 85 S/O FROM THIS FAM"
   V12433 = "85 MAIN FAM ID FOR S/0"
   V12434 = "85ID OF 1ST OTR FU IN HU"
   V12435 = "REL OF 1ST OTHER FU"
   V12436 = "SIZE OF 1ST OTHER FU"
   V12437 = "85ID OF 2ND OTR FU IN HU"
   V12438 = "REL OF 2ND OTHER FU"
   V12439 = "SIZE OF 2ND OTHER FU"
   V12440 = "85ID OF 3RD OTR FU IN HU"
   V12441 = "REL OF 3RD OTHER FU"
   V12442 = "SIZE OF 3RD OTHER FU"
   V12443 = "HOUSEHOLD ID #"
   V12444 = "FU PRIMACY WITHIN HU"
   V12445 = "1983 OLD FAMILY WEIGHT"
   V12446 = "1985 FAMILY WEIGHT";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V11103=99 THEN V11103=.;
IF V11104=999 THEN V11104=.;
IF V11105=99999 THEN V11105=.;
IF V11106=9 THEN V11106=.;
IF V11108=9 THEN V11108=.;
IF V11109=9 THEN V11109=.;
IF V11110=9 THEN V11110=.;
IF V11111=9 THEN V11111=.;
IF V11118=9999 THEN V11118=.;
IF V11119=999 THEN V11119=.;
IF V11120=99 THEN V11120=.;
IF V11121=9 THEN V11121=.;
IF V11122=99 THEN V11122=.;
IF V11139=9999 THEN V11139=.;
IF V11159=9 THEN V11159=.;
IF V11160=9 THEN V11160=.;
IF V11161=9 THEN V11161=.;
IF V11162=9 THEN V11162=.;
IF V11163=9 THEN V11163=.;
IF V11164=9 THEN V11164=.;
IF V11165=9 THEN V11165=.;
IF V11166=9 THEN V11166=.;
IF V11167=9 THEN V11167=.;
IF V11168=9 THEN V11168=.;
IF V11169=9 THEN V11169=.;
IF V11170=9 THEN V11170=.;
IF V11171=9 THEN V11171=.;
IF V11172=9 THEN V11172=.;
IF V11173=9 THEN V11173=.;
IF V11174=9 THEN V11174=.;
IF V11175=9 THEN V11175=.;
IF V11176=9 THEN V11176=.;
IF V11177=9 THEN V11177=.;
IF V11178=9 THEN V11178=.;
IF V11179=9 THEN V11179=.;
IF V11180=9 THEN V11180=.;
IF V11182=9 THEN V11182=.;
IF V11183=9 THEN V11183=.;
IF V11184=9 THEN V11184=.;
IF V11185=9 THEN V11185=.;
IF V11186=9 THEN V11186=.;
IF V11187=9 THEN V11187=.;
IF V11188=9 THEN V11188=.;
IF V11189=9 THEN V11189=.;
IF V11190=9 THEN V11190=.;
IF V11191=9 THEN V11191=.;
IF V11192=9 THEN V11192=.;
IF V11193=9 THEN V11193=.;
IF V11194=9 THEN V11194=.;
IF V11195=9 THEN V11195=.;
IF V11196=9 THEN V11196=.;
IF V11197=9 THEN V11197=.;
IF V11198=9 THEN V11198=.;
IF V11199=9 THEN V11199=.;
IF V11200=9 THEN V11200=.;
IF V11201=9 THEN V11201=.;
IF V11202=9 THEN V11202=.;
IF V11203=9 THEN V11203=.;
IF V11205=9 THEN V11205=.;
IF V11206=9 THEN V11206=.;
IF V11207=9 THEN V11207=.;
IF V11208=9 THEN V11208=.;
IF V11209=9 THEN V11209=.;
IF V11210=9 THEN V11210=.;
IF V11211=9 THEN V11211=.;
IF V11212=9 THEN V11212=.;
IF V11213=9 THEN V11213=.;
IF V11214=9 THEN V11214=.;
IF V11215=9 THEN V11215=.;
IF V11216=9 THEN V11216=.;
IF V11217=9 THEN V11217=.;
IF V11218=9 THEN V11218=.;
IF V11219=9 THEN V11219=.;
IF V11220=9 THEN V11220=.;
IF V11221=9 THEN V11221=.;
IF V11222=9 THEN V11222=.;
IF V11223=9 THEN V11223=.;
IF V11224=9 THEN V11224=.;
IF V11225=9 THEN V11225=.;
IF V11226=9 THEN V11226=.;
IF V11228=9 THEN V11228=.;
IF V11229=9 THEN V11229=.;
IF V11230=9 THEN V11230=.;
IF V11231=9 THEN V11231=.;
IF V11232=9 THEN V11232=.;
IF V11233=9 THEN V11233=.;
IF V11234=9 THEN V11234=.;
IF V11235=9 THEN V11235=.;
IF V11236=9 THEN V11236=.;
IF V11237=9 THEN V11237=.;
IF V11238=9 THEN V11238=.;
IF V11239=9 THEN V11239=.;
IF V11240=9 THEN V11240=.;
IF V11241=9 THEN V11241=.;
IF V11242=9 THEN V11242=.;
IF V11243=9 THEN V11243=.;
IF V11244=9 THEN V11244=.;
IF V11245=9 THEN V11245=.;
IF V11246=9 THEN V11246=.;
IF V11247=9 THEN V11247=.;
IF V11248=9 THEN V11248=.;
IF V11249=9 THEN V11249=.;
IF V11271=9 THEN V11271=.;
IF V11272=9 THEN V11272=.;
IF V11273=9 THEN V11273=.;
IF V11274=9 THEN V11274=.;
IF V11275=9 THEN V11275=.;
IF V11276=9 THEN V11276=.;
IF V11277=9 THEN V11277=.;
IF V11278=9 THEN V11278=.;
IF V11279=9 THEN V11279=.;
IF V11280=9 THEN V11280=.;
IF V11281=9 THEN V11281=.;
IF V11282=9 THEN V11282=.;
IF V11283=9 THEN V11283=.;
IF V11284=9 THEN V11284=.;
IF V11285=9 THEN V11285=.;
IF V11286=9 THEN V11286=.;
IF V11287=9 THEN V11287=.;
IF V11288=9 THEN V11288=.;
IF V11289=9 THEN V11289=.;
IF V11290=9 THEN V11290=.;
IF V11291=9 THEN V11291=.;
IF V11292=9 THEN V11292=.;
IF V11294=9 THEN V11294=.;
IF V11295=9 THEN V11295=.;
IF V11296=9 THEN V11296=.;
IF V11297=9 THEN V11297=.;
IF V11298=9 THEN V11298=.;
IF V11299=9 THEN V11299=.;
IF V11300=9 THEN V11300=.;
IF V11301=9 THEN V11301=.;
IF V11302=9 THEN V11302=.;
IF V11303=9 THEN V11303=.;
IF V11304=9 THEN V11304=.;
IF V11305=9 THEN V11305=.;
IF V11306=9 THEN V11306=.;
IF V11307=9 THEN V11307=.;
IF V11308=9 THEN V11308=.;
IF V11309=9 THEN V11309=.;
IF V11310=9 THEN V11310=.;
IF V11311=9 THEN V11311=.;
IF V11312=9 THEN V11312=.;
IF V11313=9 THEN V11313=.;
IF V11314=9 THEN V11314=.;
IF V11315=9 THEN V11315=.;
IF V11317=9 THEN V11317=.;
IF V11318=9 THEN V11318=.;
IF V11319=9 THEN V11319=.;
IF V11320=9 THEN V11320=.;
IF V11321=9 THEN V11321=.;
IF V11322=9 THEN V11322=.;
IF V11323=9 THEN V11323=.;
IF V11324=9 THEN V11324=.;
IF V11325=9 THEN V11325=.;
IF V11326=9 THEN V11326=.;
IF V11327=9 THEN V11327=.;
IF V11328=9 THEN V11328=.;
IF V11329=9 THEN V11329=.;
IF V11330=9 THEN V11330=.;
IF V11331=9 THEN V11331=.;
IF V11332=9 THEN V11332=.;
IF V11333=9 THEN V11333=.;
IF V11334=9 THEN V11334=.;
IF V11335=9 THEN V11335=.;
IF V11336=9 THEN V11336=.;
IF V11337=9 THEN V11337=.;
IF V11338=9 THEN V11338=.;
IF V11340=9 THEN V11340=.;
IF V11341=9 THEN V11341=.;
IF V11342=9 THEN V11342=.;
IF V11343=9 THEN V11343=.;
IF V11344=9 THEN V11344=.;
IF V11345=9 THEN V11345=.;
IF V11346=9 THEN V11346=.;
IF V11347=9 THEN V11347=.;
IF V11348=9 THEN V11348=.;
IF V11349=9 THEN V11349=.;
IF V11350=9 THEN V11350=.;
IF V11351=9 THEN V11351=.;
IF V11352=9 THEN V11352=.;
IF V11353=9 THEN V11353=.;
IF V11354=9 THEN V11354=.;
IF V11355=9 THEN V11355=.;
IF V11356=9 THEN V11356=.;
IF V11357=9 THEN V11357=.;
IF V11358=9 THEN V11358=.;
IF V11359=9 THEN V11359=.;
IF V11360=9 THEN V11360=.;
IF V11361=9 THEN V11361=.;
IF V11372=9 THEN V11372=.;
IF V11380=9 THEN V11380=.;
IF V11381=99 THEN V11381=.;
IF V11382=9 THEN V11382=.;
IF V11383=9 THEN V11383=.;
IF V11384=9 THEN V11384=.;
IF V11385=9 THEN V11385=.;
IF V11386=9 THEN V11386=.;
IF V11387=9 THEN V11387=.;
IF V11388=9 THEN V11388=.;
IF V11389=9 THEN V11389=.;
IF V11390=9 THEN V11390=.;
IF V11391=9 THEN V11391=.;
IF V11392=9 THEN V11392=.;
IF V11393=9 THEN V11393=.;
IF V11411=99 THEN V11411=.;
IF V11413=99 THEN V11413=.;
IF V11415=99 THEN V11415=.;
IF V11420=99999 THEN V11420=.;
IF V11421=99999 THEN V11421=.;
IF V11422=99999 THEN V11422=.;
IF V11429=99 THEN V11429=.;
IF V11432=99 THEN V11432=.;
IF V11434=9 THEN V11434=.;
IF V11435=99 THEN V11435=.;
IF V11437=99 THEN V11437=.;
IF V11439=9 THEN V11439=.;
IF V11442=99 THEN V11442=.;
IF V11444=99 THEN V11444=.;
IF V11446=99 THEN V11446=.;
IF V11448=99 THEN V11448=.;
IF V11450=99 THEN V11450=.;
IF V11454=99 THEN V11454=.;
IF V11456=99 THEN V11456=.;
IF V11458=99 THEN V11458=.;
IF V11462=9 THEN V11462=.;
IF V11463=9 THEN V11463=.;
IF V11464=9 THEN V11464=.;
IF V11465=9 THEN V11465=.;
IF V11466=9 THEN V11466=.;
IF V11467=9 THEN V11467=.;
IF V11468=9 THEN V11468=.;
IF V11469=9 THEN V11469=.;
IF V11470=9 THEN V11470=.;
IF V11471=9 THEN V11471=.;
IF V11472=9 THEN V11472=.;
IF V11473=9 THEN V11473=.;
IF V11474=9 THEN V11474=.;
IF V11475=9 THEN V11475=.;
IF V11476=9 THEN V11476=.;
IF V11477=9 THEN V11477=.;
IF V11478=9 THEN V11478=.;
IF V11479=9 THEN V11479=.;
IF V11480=9 THEN V11480=.;
IF V11481=9 THEN V11481=.;
IF V11482=9 THEN V11482=.;
IF V11483=9 THEN V11483=.;
IF V11484=9 THEN V11484=.;
IF V11485=9 THEN V11485=.;
IF V11486=9 THEN V11486=.;
IF V11487=9 THEN V11487=.;
IF V11488=9 THEN V11488=.;
IF V11489=9 THEN V11489=.;
IF V11490=9 THEN V11490=.;
IF V11491=9 THEN V11491=.;
IF V11492=9 THEN V11492=.;
IF V11493=9 THEN V11493=.;
IF V11494=9 THEN V11494=.;
IF V11495=9 THEN V11495=.;
IF V11496=9 THEN V11496=.;
IF V11497=9 THEN V11497=.;
IF V11498=9 THEN V11498=.;
IF V11499=9 THEN V11499=.;
IF V11500=9 THEN V11500=.;
IF V11501=9 THEN V11501=.;
IF V11502=9 THEN V11502=.;
IF V11503=9 THEN V11503=.;
IF V11504=9 THEN V11504=.;
IF V11505=9 THEN V11505=.;
IF V11506=9 THEN V11506=.;
IF V11507=9 THEN V11507=.;
IF V11508=9 THEN V11508=.;
IF V11509=9 THEN V11509=.;
IF V11510=9 THEN V11510=.;
IF V11511=9 THEN V11511=.;
IF V11512=9 THEN V11512=.;
IF V11513=9 THEN V11513=.;
IF V11514=9 THEN V11514=.;
IF V11515=9 THEN V11515=.;
IF V11516=9 THEN V11516=.;
IF V11517=9 THEN V11517=.;
IF V11518=9 THEN V11518=.;
IF V11519=9 THEN V11519=.;
IF V11520=9 THEN V11520=.;
IF V11521=9 THEN V11521=.;
IF V11522=9 THEN V11522=.;
IF V11523=9 THEN V11523=.;
IF V11524=9 THEN V11524=.;
IF V11525=9 THEN V11525=.;
IF V11526=9 THEN V11526=.;
IF V11527=9 THEN V11527=.;
IF V11528=9 THEN V11528=.;
IF V11529=9 THEN V11529=.;
IF V11530=9 THEN V11530=.;
IF V11531=9 THEN V11531=.;
IF V11532=9 THEN V11532=.;
IF V11533=9 THEN V11533=.;
IF V11599=999 THEN V11599=.;
IF V11600=9999 THEN V11600=.;
IF V11601=999 THEN V11601=.;
IF V11602=999 THEN V11602=.;
IF V11603=9999 THEN V11603=.;
IF V11604=999 THEN V11604=.;
IF V11606=99 THEN V11606=.;
IF V11608=99 THEN V11608=.;
IF V11610=99 THEN V11610=.;
IF V11611=99 THEN V11611=.;
IF V11612=9 THEN V11612=.;
IF V11613=9 THEN V11613=.;
IF V11614=99 THEN V11614=.;
IF V11615=99 THEN V11615=.;
IF V11617=9 THEN V11617=.;
IF V11619=9 THEN V11619=.;
IF V11620=99 THEN V11620=.;
IF V11621=9 THEN V11621=.;
IF V11622=9 THEN V11622=.;
IF V11623=9 THEN V11623=.;
IF V11624=9 THEN V11624=.;
IF V11625=9 THEN V11625=.;
IF V11626=9 THEN V11626=.;
IF V11627=9 THEN V11627=.;
IF V11628=9 THEN V11628=.;
IF V11629=99 THEN V11629=.;
IF V11630=9 THEN V11630=.;
IF V11631=9 THEN V11631=.;
IF V11632=9 THEN V11632=.;
IF V11633=9 THEN V11633=.;
IF V11634=9 THEN V11634=.;
IF V11635=9 THEN V11635=.;
IF V11636=99999 THEN V11636=.;
IF V11638=99 THEN V11638=.;
IF V11639=9 THEN V11639=.;
IF V11640=9 THEN V11640=.;
IF V11641=9 THEN V11641=.;
IF V11642=9 THEN V11642=.;
IF V11643=99 THEN V11643=.;
IF V11644=9 THEN V11644=.;
IF V11645=99 THEN V11645=.;
IF V11646=9 THEN V11646=.;
IF V11647=9 THEN V11647=.;
IF V11648=9 THEN V11648=.;
IF V11649=9 THEN V11649=.;
IF V11650=9 THEN V11650=.;
IF V11651=999 THEN V11651=.;
IF V11652=999 THEN V11652=.;
IF V11653=9 THEN V11653=.;
IF V11654=9999 THEN V11654=.;
IF V11655=9 THEN V11655=.;
IF V11656=9999 THEN V11656=.;
IF V11657=9999 THEN V11657=.;
IF V11658=9999 THEN V11658=.;
IF V11659=9 THEN V11659=.;
IF V11660=9999 THEN V11660=.;
IF V11661=99 THEN V11661=.;
IF V11662=9 THEN V11662=.;
IF V11663=9 THEN V11663=.;
IF V11664=9 THEN V11664=.;
IF V11665=99 THEN V11665=.;
IF V11666=9 THEN V11666=.;
IF V11667=9 THEN V11667=.;
IF V11668=999 THEN V11668=.;
IF V11669=999 THEN V11669=.;
IF V11670=99 THEN V11670=.;
IF V11671=99 THEN V11671=.;
IF V11672=9 THEN V11672=.;
IF V11673=9999 THEN V11673=.;
IF V11674=99 THEN V11674=.;
IF V11675=9 THEN V11675=.;
IF V11676=9 THEN V11676=.;
IF V11677=9 THEN V11677=.;
IF V11678=9 THEN V11678=.;
IF V11679=9 THEN V11679=.;
IF V11680=99 THEN V11680=.;
IF V11681=99 THEN V11681=.;
IF V11682=9 THEN V11682=.;
IF V11683=999 THEN V11683=.;
IF V11684=999 THEN V11684=.;
IF V11685=9999 THEN V11685=.;
IF V11686=99 THEN V11686=.;
IF V11687=99 THEN V11687=.;
IF V11688=99 THEN V11688=.;
IF V11689=9 THEN V11689=.;
IF V11690=9999 THEN V11690=.;
IF V11691=99 THEN V11691=.;
IF V11693=9 THEN V11693=.;
IF V11694=99 THEN V11694=.;
IF V11695=9 THEN V11695=.;
IF V11696=99 THEN V11696=.;
IF V11697=9 THEN V11697=.;
IF V11698=99 THEN V11698=.;
IF V11699=9 THEN V11699=.;
IF V11700=99 THEN V11700=.;
IF V11701=9 THEN V11701=.;
IF V11702=99 THEN V11702=.;
IF V11703=9 THEN V11703=.;
IF V11704=99 THEN V11704=.;
IF V11705=99 THEN V11705=.;
IF V11706=99 THEN V11706=.;
IF V11707=9 THEN V11707=.;
IF V11708=9 THEN V11708=.;
IF V11709=9 THEN V11709=.;
IF V11710=99 THEN V11710=.;
IF V11711=9999 THEN V11711=.;
IF V11712=99 THEN V11712=.;
IF V11713=99 THEN V11713=.;
IF V11714=99 THEN V11714=.;
IF V11715=9999 THEN V11715=.;
IF V11716=99 THEN V11716=.;
IF V11717=99 THEN V11717=.;
IF V11718=9 THEN V11718=.;
IF V11719=99 THEN V11719=.;
IF V11720=9 THEN V11720=.;
IF V11721=99 THEN V11721=.;
IF V11722=99 THEN V11722=.;
IF V11723=99 THEN V11723=.;
IF V11724=9 THEN V11724=.;
IF V11725=9 THEN V11725=.;
IF V11726=99 THEN V11726=.;
IF V11727=99 THEN V11727=.;
IF V11728=99 THEN V11728=.;
IF V11729=99 THEN V11729=.;
IF V11730=99 THEN V11730=.;
IF V11731=99 THEN V11731=.;
IF V11732=9 THEN V11732=.;
IF V11733=9999 THEN V11733=.;
IF V11734=9 THEN V11734=.;
IF V11735=9 THEN V11735=.;
IF V11736=9 THEN V11736=.;
IF V11737=9 THEN V11737=.;
IF V11738=9 THEN V11738=.;
IF V11739=99 THEN V11739=.;
IF V11740=99 THEN V11740=.;
IF V11743=9 THEN V11743=.;
IF V11744=9 THEN V11744=.;
IF V11745=99 THEN V11745=.;
IF V11746=9 THEN V11746=.;
IF V11747=9999 THEN V11747=.;
IF V11748=99 THEN V11748=.;
IF V11749=9 THEN V11749=.;
IF V11750=99 THEN V11750=.;
IF V11751=9 THEN V11751=.;
IF V11752=99 THEN V11752=.;
IF V11753=99 THEN V11753=.;
IF V11754=9 THEN V11754=.;
IF V11755=99 THEN V11755=.;
IF V11756=9 THEN V11756=.;
IF V11757=99 THEN V11757=.;
IF V11758=999 THEN V11758=.;
IF V11759=999 THEN V11759=.;
IF V11760=9 THEN V11760=.;
IF V11761=9 THEN V11761=.;
IF V11762=99 THEN V11762=.;
IF V11763=9 THEN V11763=.;
IF V11764=9 THEN V11764=.;
IF V11765=99 THEN V11765=.;
IF V11766=99 THEN V11766=.;
IF V11767=9999 THEN V11767=.;
IF V11768=99 THEN V11768=.;
IF V11769=99 THEN V11769=.;
IF V11770=99 THEN V11770=.;
IF V11771=9 THEN V11771=.;
IF V11772=9999 THEN V11772=.;
IF V11773=99 THEN V11773=.;
IF V11774=9 THEN V11774=.;
IF V11775=9 THEN V11775=.;
IF V11776=9 THEN V11776=.;
IF V11777=99 THEN V11777=.;
IF V11778=99 THEN V11778=.;
IF V11779=9 THEN V11779=.;
IF V11780=999 THEN V11780=.;
IF V11781=999 THEN V11781=.;
IF V11782=9999 THEN V11782=.;
IF V11783=99 THEN V11783=.;
IF V11784=99 THEN V11784=.;
IF V11785=99 THEN V11785=.;
IF V11786=9 THEN V11786=.;
IF V11787=9999 THEN V11787=.;
IF V11788=99 THEN V11788=.;
IF V11790=9 THEN V11790=.;
IF V11791=99 THEN V11791=.;
IF V11792=9 THEN V11792=.;
IF V11793=99 THEN V11793=.;
IF V11794=9 THEN V11794=.;
IF V11795=99 THEN V11795=.;
IF V11796=9 THEN V11796=.;
IF V11797=99 THEN V11797=.;
IF V11798=9 THEN V11798=.;
IF V11799=99 THEN V11799=.;
IF V11800=9 THEN V11800=.;
IF V11801=99 THEN V11801=.;
IF V11802=99 THEN V11802=.;
IF V11803=99 THEN V11803=.;
IF V11804=9 THEN V11804=.;
IF V11805=9 THEN V11805=.;
IF V11806=99 THEN V11806=.;
IF V11807=9999 THEN V11807=.;
IF V11808=99 THEN V11808=.;
IF V11809=99 THEN V11809=.;
IF V11810=99 THEN V11810=.;
IF V11811=9999 THEN V11811=.;
IF V11812=99 THEN V11812=.;
IF V11813=99 THEN V11813=.;
IF V11814=9 THEN V11814=.;
IF V11815=99 THEN V11815=.;
IF V11816=9 THEN V11816=.;
IF V11817=99 THEN V11817=.;
IF V11818=99 THEN V11818=.;
IF V11819=99 THEN V11819=.;
IF V11820=9 THEN V11820=.;
IF V11821=9 THEN V11821=.;
IF V11822=99 THEN V11822=.;
IF V11823=99 THEN V11823=.;
IF V11824=99 THEN V11824=.;
IF V11825=99 THEN V11825=.;
IF V11826=99 THEN V11826=.;
IF V11827=99 THEN V11827=.;
IF V11828=99 THEN V11828=.;
IF V11829=99 THEN V11829=.;
IF V11832=9 THEN V11832=.;
IF V11833=99 THEN V11833=.;
IF V11834=9 THEN V11834=.;
IF V11835=99 THEN V11835=.;
IF V11836=99 THEN V11836=.;
IF V11837=99 THEN V11837=.;
IF V11838=99 THEN V11838=.;
IF V11839=99 THEN V11839=.;
IF V11840=99 THEN V11840=.;
IF V11841=99 THEN V11841=.;
IF V11842=99 THEN V11842=.;
IF V11844=99 THEN V11844=.;
IF V11846=9 THEN V11846=.;
IF V11848=9 THEN V11848=.;
IF V11849=99 THEN V11849=.;
IF V11850=99 THEN V11850=.;
IF V11851=99 THEN V11851=.;
IF V11852=99 THEN V11852=.;
IF V11853=9 THEN V11853=.;
IF V11854=9 THEN V11854=.;
IF V11855=99 THEN V11855=.;
IF V11856=99 THEN V11856=.;
IF V11857=9 THEN V11857=.;
IF V11858=99 THEN V11858=.;
IF V11859=99 THEN V11859=.;
IF V11860=9 THEN V11860=.;
IF V11861=9 THEN V11861=.;
IF V11862=99 THEN V11862=.;
IF V11863=99 THEN V11863=.;
IF V11865=9 THEN V11865=.;
IF V11866=9 THEN V11866=.;
IF V11867=9 THEN V11867=.;
IF V11868=9 THEN V11868=.;
IF V11869=9 THEN V11869=.;
IF V11870=9 THEN V11870=.;
IF V11871=99 THEN V11871=.;
IF V11873=9 THEN V11873=.;
IF V11874=9 THEN V11874=.;
IF V11875=9 THEN V11875=.;
IF V11876=9 THEN V11876=.;
IF V11877=9 THEN V11877=.;
IF V11878=9 THEN V11878=.;
IF V11879=99 THEN V11879=.;
IF V11880=9 THEN V11880=.;
IF V11881=99 THEN V11881=.;
IF V11882=99 THEN V11882=.;
IF V11883=9 THEN V11883=.;
IF V11884=99 THEN V11884=.;
IF V11885=99 THEN V11885=.;
IF V11886=9 THEN V11886=.;
IF V11887=999999 THEN V11887=.;
IF V11888=9 THEN V11888=.;
IF V11889=99 THEN V11889=.;
IF V11890=9 THEN V11890=.;
IF V11891=9 THEN V11891=.;
IF V11892=9 THEN V11892=.;
IF V11893=9 THEN V11893=.;
IF V11894=999999 THEN V11894=.;
IF V11895=9 THEN V11895=.;
IF V11896=9 THEN V11896=.;
IF V11897=9 THEN V11897=.;
IF V11898=99 THEN V11898=.;
IF V11899=99 THEN V11899=.;
IF V11900=99 THEN V11900=.;
IF V11901=9 THEN V11901=.;
IF V11902=9 THEN V11902=.;
IF V11903=9 THEN V11903=.;
IF V11904=9 THEN V11904=.;
IF V11905=9 THEN V11905=.;
IF V11907=99 THEN V11907=.;
IF V11908=999 THEN V11908=.;
IF V11909=99 THEN V11909=.;
IF V11910=999 THEN V11910=.;
IF V11911=9 THEN V11911=.;
IF V11912=9 THEN V11912=.;
IF V11913=9 THEN V11913=.;
IF V11914=9 THEN V11914=.;
IF V11915=99 THEN V11915=.;
IF V11916=999 THEN V11916=.;
IF V11917=9 THEN V11917=.;
IF V11918=9 THEN V11918=.;
IF V11919=9 THEN V11919=.;
IF V11920=9 THEN V11920=.;
IF V11921=9 THEN V11921=.;
IF V11922=9 THEN V11922=.;
IF V11923=9 THEN V11923=.;
IF V11924=9 THEN V11924=.;
IF V11925=99 THEN V11925=.;
IF V11926=9 THEN V11926=.;
IF V11927=9 THEN V11927=.;
IF V11928=99 THEN V11928=.;
IF V11929=9 THEN V11929=.;
IF V11930=9 THEN V11930=.;
IF V11931=99 THEN V11931=.;
IF V11932=9 THEN V11932=.;
IF V11933=9 THEN V11933=.;
IF V11934=99 THEN V11934=.;
IF V11935=9 THEN V11935=.;
IF V11936=9 THEN V11936=.;
IF V11937=9 THEN V11937=.;
IF V11938=9 THEN V11938=.;
IF V11939=9 THEN V11939=.;
IF V11940=9 THEN V11940=.;
IF V11941=99 THEN V11941=.;
IF V11942=99 THEN V11942=.;
IF V11943=99 THEN V11943=.;
IF V11944=99 THEN V11944=.;
IF V11945=9 THEN V11945=.;
IF V11946=99 THEN V11946=.;
IF V11947=99 THEN V11947=.;
IF V11948=99 THEN V11948=.;
IF V11949=99 THEN V11949=.;
IF V11950=99 THEN V11950=.;
IF V11951=99 THEN V11951=.;
IF V11952=99 THEN V11952=.;
IF V11953=99 THEN V11953=.;
IF V11954=99 THEN V11954=.;
IF V11955=99 THEN V11955=.;
IF V11956=9 THEN V11956=.;
IF V11957=99 THEN V11957=.;
IF V11958=99 THEN V11958=.;
IF V11959=9 THEN V11959=.;
IF V11960=9 THEN V11960=.;
IF V11961=99 THEN V11961=.;
IF V11962=99 THEN V11962=.;
IF V11963=99 THEN V11963=.;
IF V11964=9 THEN V11964=.;
IF V11965=9 THEN V11965=.;
IF V11966=9 THEN V11966=.;
IF V11967=99 THEN V11967=.;
IF V11968=99 THEN V11968=.;
IF V11969=99 THEN V11969=.;
IF V11970=99 THEN V11970=.;
IF V11971=9 THEN V11971=.;
IF V11972=99 THEN V11972=.;
IF V11973=99 THEN V11973=.;
IF V11974=99 THEN V11974=.;
IF V11975=99 THEN V11975=.;
IF V11976=9 THEN V11976=.;
IF V11977=99 THEN V11977=.;
IF V11978=99 THEN V11978=.;
IF V11979=99 THEN V11979=.;
IF V11980=99 THEN V11980=.;
IF V11981=99 THEN V11981=.;
IF V11982=99 THEN V11982=.;
IF V11984=9 THEN V11984=.;
IF V11986=99 THEN V11986=.;
IF V11987=99 THEN V11987=.;
IF V11988=99 THEN V11988=.;
IF V11989=9 THEN V11989=.;
IF V11990=99999 THEN V11990=.;
IF V11991=9 THEN V11991=.;
IF V11992=9 THEN V11992=.;
IF V11993=9 THEN V11993=.;
IF V11994=9 THEN V11994=.;
IF V11995=9 THEN V11995=.;
IF V11996=999 THEN V11996=.;
IF V11997=9 THEN V11997=.;
IF V11998=9 THEN V11998=.;
IF V12001=99 THEN V12001=.;
IF V12002=9 THEN V12002=.;
IF V12003=9 THEN V12003=.;
IF V12004=9 THEN V12004=.;
IF V12005=9 THEN V12005=.;
IF V12006=99 THEN V12006=.;
IF V12007=9 THEN V12007=.;
IF V12008=99 THEN V12008=.;
IF V12009=9 THEN V12009=.;
IF V12010=9 THEN V12010=.;
IF V12011=9 THEN V12011=.;
IF V12012=9 THEN V12012=.;
IF V12013=9 THEN V12013=.;
IF V12014=999 THEN V12014=.;
IF V12015=999 THEN V12015=.;
IF V12016=9 THEN V12016=.;
IF V12017=9999 THEN V12017=.;
IF V12018=9 THEN V12018=.;
IF V12019=9999 THEN V12019=.;
IF V12020=9999 THEN V12020=.;
IF V12021=9999 THEN V12021=.;
IF V12022=9 THEN V12022=.;
IF V12023=9999 THEN V12023=.;
IF V12024=99 THEN V12024=.;
IF V12025=9 THEN V12025=.;
IF V12026=9 THEN V12026=.;
IF V12027=9 THEN V12027=.;
IF V12028=99 THEN V12028=.;
IF V12029=9 THEN V12029=.;
IF V12030=9 THEN V12030=.;
IF V12031=999 THEN V12031=.;
IF V12032=999 THEN V12032=.;
IF V12033=99 THEN V12033=.;
IF V12034=99 THEN V12034=.;
IF V12035=9 THEN V12035=.;
IF V12036=9999 THEN V12036=.;
IF V12037=99 THEN V12037=.;
IF V12038=9 THEN V12038=.;
IF V12039=9 THEN V12039=.;
IF V12040=9 THEN V12040=.;
IF V12041=9 THEN V12041=.;
IF V12042=9 THEN V12042=.;
IF V12043=99 THEN V12043=.;
IF V12044=99 THEN V12044=.;
IF V12045=9 THEN V12045=.;
IF V12046=999 THEN V12046=.;
IF V12047=999 THEN V12047=.;
IF V12048=9999 THEN V12048=.;
IF V12049=99 THEN V12049=.;
IF V12050=99 THEN V12050=.;
IF V12051=99 THEN V12051=.;
IF V12052=9 THEN V12052=.;
IF V12053=9999 THEN V12053=.;
IF V12054=99 THEN V12054=.;
IF V12056=9 THEN V12056=.;
IF V12057=99 THEN V12057=.;
IF V12058=9 THEN V12058=.;
IF V12059=99 THEN V12059=.;
IF V12060=9 THEN V12060=.;
IF V12061=99 THEN V12061=.;
IF V12062=9 THEN V12062=.;
IF V12063=99 THEN V12063=.;
IF V12064=9 THEN V12064=.;
IF V12065=99 THEN V12065=.;
IF V12066=9 THEN V12066=.;
IF V12067=99 THEN V12067=.;
IF V12068=99 THEN V12068=.;
IF V12069=99 THEN V12069=.;
IF V12070=9 THEN V12070=.;
IF V12071=9 THEN V12071=.;
IF V12072=9 THEN V12072=.;
IF V12073=99 THEN V12073=.;
IF V12074=9999 THEN V12074=.;
IF V12075=99 THEN V12075=.;
IF V12076=99 THEN V12076=.;
IF V12077=99 THEN V12077=.;
IF V12078=9999 THEN V12078=.;
IF V12079=99 THEN V12079=.;
IF V12080=99 THEN V12080=.;
IF V12081=9 THEN V12081=.;
IF V12082=99 THEN V12082=.;
IF V12083=9 THEN V12083=.;
IF V12084=99 THEN V12084=.;
IF V12085=99 THEN V12085=.;
IF V12086=99 THEN V12086=.;
IF V12087=9 THEN V12087=.;
IF V12088=9 THEN V12088=.;
IF V12089=99 THEN V12089=.;
IF V12090=99 THEN V12090=.;
IF V12091=99 THEN V12091=.;
IF V12092=99 THEN V12092=.;
IF V12093=99 THEN V12093=.;
IF V12094=99 THEN V12094=.;
IF V12095=9 THEN V12095=.;
IF V12096=9999 THEN V12096=.;
IF V12097=9 THEN V12097=.;
IF V12098=9 THEN V12098=.;
IF V12099=9 THEN V12099=.;
IF V12100=9 THEN V12100=.;
IF V12101=9 THEN V12101=.;
IF V12102=99 THEN V12102=.;
IF V12103=99 THEN V12103=.;
IF V12106=9 THEN V12106=.;
IF V12107=9 THEN V12107=.;
IF V12108=99 THEN V12108=.;
IF V12109=9 THEN V12109=.;
IF V12110=9999 THEN V12110=.;
IF V12111=99 THEN V12111=.;
IF V12112=9 THEN V12112=.;
IF V12113=99 THEN V12113=.;
IF V12114=9 THEN V12114=.;
IF V12115=99 THEN V12115=.;
IF V12116=99 THEN V12116=.;
IF V12117=9 THEN V12117=.;
IF V12118=99 THEN V12118=.;
IF V12119=9 THEN V12119=.;
IF V12120=99 THEN V12120=.;
IF V12121=999 THEN V12121=.;
IF V12122=999 THEN V12122=.;
IF V12123=9 THEN V12123=.;
IF V12124=9 THEN V12124=.;
IF V12125=99 THEN V12125=.;
IF V12126=9 THEN V12126=.;
IF V12127=9 THEN V12127=.;
IF V12128=99 THEN V12128=.;
IF V12129=99 THEN V12129=.;
IF V12130=9999 THEN V12130=.;
IF V12131=99 THEN V12131=.;
IF V12132=99 THEN V12132=.;
IF V12133=99 THEN V12133=.;
IF V12134=9 THEN V12134=.;
IF V12135=9999 THEN V12135=.;
IF V12136=99 THEN V12136=.;
IF V12137=9 THEN V12137=.;
IF V12138=9 THEN V12138=.;
IF V12139=9 THEN V12139=.;
IF V12140=99 THEN V12140=.;
IF V12141=99 THEN V12141=.;
IF V12142=9 THEN V12142=.;
IF V12143=999 THEN V12143=.;
IF V12144=999 THEN V12144=.;
IF V12145=9999 THEN V12145=.;
IF V12146=99 THEN V12146=.;
IF V12147=99 THEN V12147=.;
IF V12148=99 THEN V12148=.;
IF V12149=9 THEN V12149=.;
IF V12150=9999 THEN V12150=.;
IF V12151=99 THEN V12151=.;
IF V12153=9 THEN V12153=.;
IF V12154=99 THEN V12154=.;
IF V12155=9 THEN V12155=.;
IF V12156=99 THEN V12156=.;
IF V12157=9 THEN V12157=.;
IF V12158=99 THEN V12158=.;
IF V12159=9 THEN V12159=.;
IF V12160=99 THEN V12160=.;
IF V12161=9 THEN V12161=.;
IF V12162=99 THEN V12162=.;
IF V12163=9 THEN V12163=.;
IF V12164=99 THEN V12164=.;
IF V12165=99 THEN V12165=.;
IF V12166=99 THEN V12166=.;
IF V12167=9 THEN V12167=.;
IF V12168=9 THEN V12168=.;
IF V12169=99 THEN V12169=.;
IF V12170=9999 THEN V12170=.;
IF V12171=99 THEN V12171=.;
IF V12172=99 THEN V12172=.;
IF V12173=99 THEN V12173=.;
IF V12174=9999 THEN V12174=.;
IF V12175=99 THEN V12175=.;
IF V12176=99 THEN V12176=.;
IF V12177=9 THEN V12177=.;
IF V12178=99 THEN V12178=.;
IF V12179=9 THEN V12179=.;
IF V12180=99 THEN V12180=.;
IF V12181=99 THEN V12181=.;
IF V12182=99 THEN V12182=.;
IF V12183=9 THEN V12183=.;
IF V12184=9 THEN V12184=.;
IF V12185=99 THEN V12185=.;
IF V12186=99 THEN V12186=.;
IF V12187=99 THEN V12187=.;
IF V12188=99 THEN V12188=.;
IF V12189=99 THEN V12189=.;
IF V12190=99 THEN V12190=.;
IF V12191=99 THEN V12191=.;
IF V12192=99 THEN V12192=.;
IF V12196=9 THEN V12196=.;
IF V12197=9 THEN V12197=.;
IF V12198=99 THEN V12198=.;
IF V12199=9 THEN V12199=.;
IF V12200=99 THEN V12200=.;
IF V12201=99 THEN V12201=.;
IF V12202=99 THEN V12202=.;
IF V12203=99 THEN V12203=.;
IF V12204=99 THEN V12204=.;
IF V12205=99 THEN V12205=.;
IF V12206=99 THEN V12206=.;
IF V12207=99 THEN V12207=.;
IF V12208=99 THEN V12208=.;
IF V12209=99 THEN V12209=.;
IF V12211=9 THEN V12211=.;
IF V12213=9 THEN V12213=.;
IF V12214=99 THEN V12214=.;
IF V12215=99 THEN V12215=.;
IF V12216=9 THEN V12216=.;
IF V12217=9 THEN V12217=.;
IF V12218=9 THEN V12218=.;
IF V12219=9 THEN V12219=.;
IF V12220=9 THEN V12220=.;
IF V12221=9 THEN V12221=.;
IF V12222=9 THEN V12222=.;
IF V12223=9 THEN V12223=.;
IF V12224=9 THEN V12224=.;
IF V12225=9 THEN V12225=.;
IF V12226=9 THEN V12226=.;
IF V12227=99 THEN V12227=.;
IF V12228=99 THEN V12228=.;
IF V12229=9 THEN V12229=.;
IF V12230=9 THEN V12230=.;
IF V12231=99 THEN V12231=.;
IF V12232=99 THEN V12232=.;
IF V12233=9 THEN V12233=.;
IF V12234=9 THEN V12234=.;
IF V12235=9 THEN V12235=.;
IF V12236=99 THEN V12236=.;
IF V12237=99 THEN V12237=.;
IF V12238=9 THEN V12238=.;
IF V12240=9 THEN V12240=.;
IF V12241=9 THEN V12241=.;
IF V12242=9 THEN V12242=.;
IF V12243=9 THEN V12243=.;
IF V12244=9 THEN V12244=.;
IF V12245=9 THEN V12245=.;
IF V12246=99 THEN V12246=.;
IF V12248=9 THEN V12248=.;
IF V12249=9 THEN V12249=.;
IF V12250=9 THEN V12250=.;
IF V12251=9 THEN V12251=.;
IF V12252=9 THEN V12252=.;
IF V12253=9 THEN V12253=.;
IF V12254=99 THEN V12254=.;
IF V12255=9 THEN V12255=.;
IF V12256=99 THEN V12256=.;
IF V12257=99 THEN V12257=.;
IF V12258=9 THEN V12258=.;
IF V12259=99 THEN V12259=.;
IF V12260=99 THEN V12260=.;
IF V12262=99 THEN V12262=.;
IF V12263=999 THEN V12263=.;
IF V12264=99 THEN V12264=.;
IF V12265=999 THEN V12265=.;
IF V12266=9 THEN V12266=.;
IF V12267=9 THEN V12267=.;
IF V12268=9 THEN V12268=.;
IF V12269=9 THEN V12269=.;
IF V12270=99 THEN V12270=.;
IF V12271=999 THEN V12271=.;
IF V12272=9 THEN V12272=.;
IF V12273=9 THEN V12273=.;
IF V12274=9 THEN V12274=.;
IF V12275=9 THEN V12275=.;
IF V12276=9 THEN V12276=.;
IF V12277=9 THEN V12277=.;
IF V12278=9 THEN V12278=.;
IF V12279=9 THEN V12279=.;
IF V12280=99 THEN V12280=.;
IF V12281=9 THEN V12281=.;
IF V12282=9 THEN V12282=.;
IF V12283=99 THEN V12283=.;
IF V12284=9 THEN V12284=.;
IF V12285=9 THEN V12285=.;
IF V12286=99 THEN V12286=.;
IF V12287=9 THEN V12287=.;
IF V12288=9 THEN V12288=.;
IF V12289=99 THEN V12289=.;
IF V12290=9 THEN V12290=.;
IF V12291=9 THEN V12291=.;
IF V12292=9 THEN V12292=.;
IF V12293=9 THEN V12293=.;
IF V12294=9 THEN V12294=.;
IF V12295=9 THEN V12295=.;
IF V12296=99 THEN V12296=.;
IF V12297=99 THEN V12297=.;
IF V12298=99 THEN V12298=.;
IF V12299=99 THEN V12299=.;
IF V12300=9 THEN V12300=.;
IF V12301=99 THEN V12301=.;
IF V12302=99 THEN V12302=.;
IF V12303=99 THEN V12303=.;
IF V12304=99 THEN V12304=.;
IF V12305=99 THEN V12305=.;
IF V12306=99 THEN V12306=.;
IF V12307=99 THEN V12307=.;
IF V12308=99 THEN V12308=.;
IF V12309=99 THEN V12309=.;
IF V12310=99 THEN V12310=.;
IF V12311=9 THEN V12311=.;
IF V12312=99 THEN V12312=.;
IF V12313=99 THEN V12313=.;
IF V12314=9 THEN V12314=.;
IF V12315=9 THEN V12315=.;
IF V12316=99 THEN V12316=.;
IF V12317=99 THEN V12317=.;
IF V12318=99 THEN V12318=.;
IF V12319=9 THEN V12319=.;
IF V12320=9 THEN V12320=.;
IF V12321=9 THEN V12321=.;
IF V12322=99 THEN V12322=.;
IF V12323=99 THEN V12323=.;
IF V12324=99 THEN V12324=.;
IF V12325=99 THEN V12325=.;
IF V12326=9 THEN V12326=.;
IF V12327=99 THEN V12327=.;
IF V12328=99 THEN V12328=.;
IF V12329=99 THEN V12329=.;
IF V12330=99 THEN V12330=.;
IF V12331=9 THEN V12331=.;
IF V12332=99 THEN V12332=.;
IF V12333=99 THEN V12333=.;
IF V12334=99 THEN V12334=.;
IF V12335=99 THEN V12335=.;
IF V12336=99 THEN V12336=.;
IF V12337=99 THEN V12337=.;
IF V12339=99 THEN V12339=.;
IF V12340=99 THEN V12340=.;
IF V12341=99 THEN V12341=.;
IF V12342=9 THEN V12342=.;
IF V12343=99999 THEN V12343=.;
IF V12344=9 THEN V12344=.;
IF V12345=9 THEN V12345=.;
IF V12346=9 THEN V12346=.;
IF V12347=9 THEN V12347=.;
IF V12348=9 THEN V12348=.;
IF V12349=999 THEN V12349=.;
IF V12351=9 THEN V12351=.;
IF V12352=9 THEN V12352=.;
IF V12353=99 THEN V12353=.;
IF V12354=9 THEN V12354=.;
IF V12355=9 THEN V12355=.;
IF V12356=99 THEN V12356=.;
IF V12379=9 THEN V12379=.;
IF V12380=99 THEN V12380=.;
IF V12381=999 THEN V12381=.;
IF V12382=99 THEN V12382=.;
IF V12383=9 THEN V12383=.;
IF V12384=9 THEN V12384=.;
IF V12385=9 THEN V12385=.;
IF V12386=9 THEN V12386=.;
IF V12387=9 THEN V12387=.;
IF V12388=9 THEN V12388=.;
IF V12389=9 THEN V12389=.;
IF V12390=9 THEN V12390=.;
IF V12394=99999 THEN V12394=.;
IF V12395=9 THEN V12395=.;
IF V12396=9.9 THEN V12396=.;
IF V12398=9 THEN V12398=.;
IF V12399=9 THEN V12399=.;
IF V12400=9 THEN V12400=.;
IF V12401=9 THEN V12401=.;
IF V12422=9 THEN V12422=.;
IF V12423=9999 THEN V12423=.;
IF V12424=99 THEN V12424=.;
 
file rawdat lrecl=2456;
put    
v11102
v11112
v11125
v11126
v11127
v11133
v11134
v11137
v11138
v11146
v11147
v11149
v11258
v11259
v11261
v11373
v11374
v11375
v11376
v11377
v11378
v11379
v11380
v11403
v11404
v11405
v11412
v11414
v11417
v11419
v11461
v11560
v11561
v11563
v11577
v11600
v11605
v11606
v11607
v11608
v11618
v11619
v11620
v11621
v11628
v11629
v11630
v11635
v11637
v11640
v11668
v11679
v11705
v11706
v11748
v11764
v11802
v11803
v11894
v11897
v11906
v11938
v11945
v11956
v11960
v11993
v12000
v12002
v12003
v12031
v12042
v12068
v12069
v12111
v12127
v12165
v12166
v12300
v12311
v12315
v12358
v12359
v12370
v12371
v12372
v12374
v12379
v12391
v12400
v12401
v12426
v12446
v30481
;

 proc means;
 run; 
